/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.annotation;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.RetryAwareServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.XForwardedHeadersTransformer;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.loadbalancer.support.LoadBalancerEnvironmentPropertyUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.util.retry.RetrySpec;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
public class LoadBalancerClientConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;

    @Bean
    @ConditionalOnMissingBean
    public ReactorLoadBalancer<ServiceInstance> reactorServiceInstanceLoadBalancer(Environment environment2, LoadBalancerClientFactory loadBalancerClientFactory) {
        String name = environment2.getProperty("loadbalancer.client.name");
        return new RoundRobinLoadBalancer(loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name);
    }

    static class SubsetConfigurationCondition
    implements Condition {
        SubsetConfigurationCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(context.getEnvironment(), "configurations", "subset");
        }
    }

    static class WeightedConfigurationCondition
    implements Condition {
        WeightedConfigurationCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(context.getEnvironment(), "configurations", "weighted");
        }
    }

    static class SameInstancePreferenceConfigurationCondition
    implements Condition {
        SameInstancePreferenceConfigurationCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(context.getEnvironment(), "configurations", "same-instance-preference");
        }
    }

    static class RequestBasedStickySessionConfigurationCondition
    implements Condition {
        RequestBasedStickySessionConfigurationCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(context.getEnvironment(), "configurations", "request-based-sticky-session");
        }
    }

    static class HealthCheckConfigurationCondition
    implements Condition {
        HealthCheckConfigurationCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(context.getEnvironment(), "configurations", "health-check");
        }
    }

    static class ZonePreferenceConfigurationCondition
    implements Condition {
        ZonePreferenceConfigurationCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(context.getEnvironment(), "configurations", "zone-preference");
        }
    }

    static class DefaultConfigurationCondition
    implements Condition {
        DefaultConfigurationCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.equalToOrMissingForClientOrDefault(context.getEnvironment(), "configurations", "default");
        }
    }

    static class AvoidPreviousInstanceEnabledCondition
    implements Condition {
        AvoidPreviousInstanceEnabledCondition() {
        }

        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return LoadBalancerEnvironmentPropertyUtils.trueOrMissingForClientOrDefault(context.getEnvironment(), "retry.avoid-previous-instance");
        }
    }

    static final class ReactiveOnAvoidPreviousInstanceAndRetryEnabledCondition
    extends AllNestedConditions {
        private ReactiveOnAvoidPreviousInstanceAndRetryEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Conditional(value={AvoidPreviousInstanceEnabledCondition.class})
        static class AvoidPreviousInstanceEnabled {
            AvoidPreviousInstanceEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true")
        static class LoadBalancerRetryEnabled {
            LoadBalancerRetryEnabled() {
            }
        }
    }

    static final class BlockingOnAvoidPreviousInstanceAndRetryEnabledCondition
    extends AllNestedConditions {
        private BlockingOnAvoidPreviousInstanceAndRetryEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Conditional(value={AvoidPreviousInstanceEnabledCondition.class})
        static class AvoidPreviousInstanceEnabled {
            AvoidPreviousInstanceEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true", matchIfMissing=true)
        static class LoadBalancerRetryEnabled {
            LoadBalancerRetryEnabled() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Conditional(value={ReactiveOnAvoidPreviousInstanceAndRetryEnabledCondition.class})
    @AutoConfigureAfter(value={ReactiveSupportConfiguration.class})
    @ConditionalOnBean(value={ServiceInstanceListSupplier.class})
    @ConditionalOnClass(value={RetrySpec.class})
    public static class ReactiveRetryConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @Primary
        public ServiceInstanceListSupplier retryAwareDiscoveryClientServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
            return new RetryAwareServiceInstanceListSupplier(delegate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @ConditionalOnClass(value={RetryTemplate.class})
    @Conditional(value={BlockingOnAvoidPreviousInstanceAndRetryEnabledCondition.class})
    @AutoConfigureAfter(value={BlockingSupportConfiguration.class})
    @ConditionalOnBean(value={ServiceInstanceListSupplier.class})
    public static class BlockingRetryConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @Primary
        public ServiceInstanceListSupplier retryAwareDiscoveryClientServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
            return new RetryAwareServiceInstanceListSupplier(delegate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=193827466)
    public static class BlockingSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={DefaultConfigurationCondition.class})
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withCaching().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={ZonePreferenceConfigurationCondition.class})
        public ServiceInstanceListSupplier zonePreferenceDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withCaching().withZonePreference().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class, RestTemplate.class})
        @ConditionalOnMissingBean
        @Conditional(value={HealthCheckConfigurationCondition.class})
        public ServiceInstanceListSupplier healthCheckDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withBlockingHealthChecks().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class, RestClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={HealthCheckConfigurationCondition.class})
        public ServiceInstanceListSupplier healthCheckRestClientDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withBlockingRestClientHealthChecks().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={RequestBasedStickySessionConfigurationCondition.class})
        public ServiceInstanceListSupplier requestBasedStickySessionDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withCaching().withRequestBasedStickySession().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={SameInstancePreferenceConfigurationCondition.class})
        public ServiceInstanceListSupplier sameInstancePreferenceServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withCaching().withSameInstancePreference().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={WeightedConfigurationCondition.class})
        public ServiceInstanceListSupplier weightedServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withCaching().withWeighted().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={SubsetConfigurationCondition.class})
        public ServiceInstanceListSupplier subsetServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withSubset().withCaching().build(context);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=193827465)
    public static class ReactiveSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={DefaultConfigurationCondition.class})
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withCaching().build(context);
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={ZonePreferenceConfigurationCondition.class})
        public ServiceInstanceListSupplier zonePreferenceDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withCaching().withZonePreference().build(context);
        }

        @Bean
        @ConditionalOnBean(value={LoadBalancerClientFactory.class})
        @ConditionalOnMissingBean
        public XForwardedHeadersTransformer xForwarderHeadersTransformer(LoadBalancerClientFactory clientFactory) {
            return new XForwardedHeadersTransformer(clientFactory);
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class, WebClient.Builder.class})
        @ConditionalOnMissingBean
        @Conditional(value={HealthCheckConfigurationCondition.class})
        public ServiceInstanceListSupplier healthCheckDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withHealthChecks().build(context);
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={RequestBasedStickySessionConfigurationCondition.class})
        public ServiceInstanceListSupplier requestBasedStickySessionDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withCaching().withRequestBasedStickySession().build(context);
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={SameInstancePreferenceConfigurationCondition.class})
        public ServiceInstanceListSupplier sameInstancePreferenceServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withCaching().withSameInstancePreference().build(context);
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={WeightedConfigurationCondition.class})
        public ServiceInstanceListSupplier weightedServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withCaching().withWeighted().build(context);
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @Conditional(value={SubsetConfigurationCondition.class})
        public ServiceInstanceListSupplier subsetServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withSubset().withCaching().build(context);
        }
    }
}

