/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebMvcConfigurer.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value={"spring.cloud.mvc.token-relay.enabled"}, matchIfMissing=true)
public class ResourceServerTokenRelayAutoConfiguration {

    private static class OAuth2OnClientInResourceServerCondition
    extends AllNestedConditions {
        OAuth2OnClientInResourceServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={OAuth2OnClientInResourceServerCondition.class})
    static @interface ConditionalOnOAuth2ClientInResourceServer {
    }

    @Configuration(proxyBeanMethods=false)
    public static class ResourceServerTokenRelayRegistrationAutoConfiguration
    implements WebMvcConfigurer {
        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(new HandlerInterceptor(){

                @Override
                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
                    return true;
                }
            });
        }
    }
}

