/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.client.loadbalancer.RetryableRequestContext;
import org.springframework.cloud.client.loadbalancer.reactive.ExchangeFilterFunctionUtils;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancedExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryContext;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableStatusCodeException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetrySpec;

public class RetryableLoadBalancerExchangeFilterFunction
implements LoadBalancedExchangeFilterFunction {
    private static final Log LOG = LogFactory.getLog(RetryableLoadBalancerExchangeFilterFunction.class);
    private final LoadBalancerRetryPolicy.Factory retryPolicyFactory;
    private final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;
    private final List<LoadBalancerClientRequestTransformer> transformers;

    public RetryableLoadBalancerExchangeFilterFunction(LoadBalancerRetryPolicy.Factory retryPolicyFactory, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory, List<LoadBalancerClientRequestTransformer> transformers) {
        this.retryPolicyFactory = retryPolicyFactory;
        this.loadBalancerFactory = loadBalancerFactory;
        this.transformers = transformers;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction next) {
        URI originalUrl = clientRequest.url();
        String serviceId = originalUrl.getHost();
        if (serviceId == null) {
            String message = String.format("Request URI does not contain a valid hostname: %s", originalUrl);
            if (LOG.isWarnEnabled()) {
                LOG.warn(message);
            }
            return Mono.just(ClientResponse.create((HttpStatusCode)HttpStatus.BAD_REQUEST).body(message).build());
        }
        LoadBalancerRetryContext loadBalancerRetryContext = new LoadBalancerRetryContext(clientRequest);
        LoadBalancerProperties properties = this.loadBalancerFactory.getProperties(serviceId);
        LoadBalancerRetryPolicy retryPolicy = (LoadBalancerRetryPolicy)this.retryPolicyFactory.apply(serviceId);
        Retry exchangeRetry = this.buildRetrySpec(properties.getRetry().getMaxRetriesOnSameServiceInstance(), true, properties.getRetry(), retryPolicy);
        Retry filterRetry = this.buildRetrySpec(properties.getRetry().getMaxRetriesOnNextServiceInstance(), false, properties.getRetry(), retryPolicy);
        Set<LoadBalancerLifecycle> supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors(this.loadBalancerFactory.getInstances(serviceId, LoadBalancerLifecycle.class), RetryableRequestContext.class, ResponseData.class, ServiceInstance.class);
        String hint = ExchangeFilterFunctionUtils.getHint(serviceId, properties.getHint());
        RequestData requestData = new RequestData(clientRequest);
        DefaultRequest<RetryableRequestContext> lbRequest = new DefaultRequest<RetryableRequestContext>(new RetryableRequestContext(null, requestData, hint));
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart(lbRequest));
        return Mono.defer(() -> this.choose(serviceId, lbRequest).flatMap(lbResponse -> {
            ServiceInstance instance = (ServiceInstance)lbResponse.getServer();
            lbRequest.setContext(new RetryableRequestContext(instance, requestData, hint));
            if (instance == null) {
                String message = ExchangeFilterFunctionUtils.serviceInstanceUnavailableMessage(serviceId);
                if (LOG.isWarnEnabled()) {
                    LOG.warn(message);
                }
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, lbRequest, lbResponse)));
                return Mono.just(ClientResponse.create((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body(ExchangeFilterFunctionUtils.serviceInstanceUnavailableMessage(serviceId)).build());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("LoadBalancer has retrieved the instance for service %s: %s", serviceId, instance.getUri()));
            }
            LoadBalancerProperties.StickySession stickySessionProperties = properties.getStickySession();
            ClientRequest newRequest = ExchangeFilterFunctionUtils.buildClientRequest(clientRequest, instance, stickySessionProperties.getInstanceIdCookieName(), stickySessionProperties.isAddServiceInstanceCookie(), this.transformers);
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStartRequest(lbRequest, lbResponse));
            return next.exchange(newRequest).doOnError(throwable -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)throwable, lbRequest, lbResponse)))).doOnSuccess(clientResponse -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, lbRequest, lbResponse, new ResponseData((ClientResponse)clientResponse, requestData))))).map(clientResponse -> {
                loadBalancerRetryContext.setClientResponse((ClientResponse)clientResponse);
                if (this.shouldRetrySameServiceInstance(retryPolicy, loadBalancerRetryContext)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Retrying on status code: %d", clientResponse.statusCode().value()));
                    }
                    throw new RetryableStatusCodeException();
                }
                return clientResponse;
            });
        }).map(clientResponse -> {
            loadBalancerRetryContext.setClientResponse((ClientResponse)clientResponse);
            if (this.shouldRetryNextServiceInstance(retryPolicy, loadBalancerRetryContext)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Retrying on status code: %d", clientResponse.statusCode().value()));
                }
                throw new RetryableStatusCodeException();
            }
            return clientResponse;
        }).retryWhen(exchangeRetry)).retryWhen(filterRetry);
    }

    private Retry buildRetrySpec(int max, boolean transientErrors, LoadBalancerProperties.Retry retry, LoadBalancerRetryPolicy retryPolicy) {
        if (!retry.isEnabled()) {
            return Retry.max(0L).filter(throwable -> this.isRetryException((Throwable)throwable, retryPolicy)).transientErrors(transientErrors);
        }
        LoadBalancerProperties.Retry.Backoff backoffProperties = retry.getBackoff();
        if (backoffProperties.isEnabled()) {
            return RetrySpec.backoff(max, backoffProperties.getMinBackoff()).filter(throwable -> this.isRetryException((Throwable)throwable, retryPolicy)).maxBackoff(backoffProperties.getMaxBackoff()).jitter(backoffProperties.getJitter()).transientErrors(transientErrors);
        }
        return RetrySpec.max(max).filter(throwable -> this.isRetryException((Throwable)throwable, retryPolicy)).transientErrors(transientErrors);
    }

    private boolean shouldRetrySameServiceInstance(LoadBalancerRetryPolicy retryPolicy, LoadBalancerRetryContext loadBalancerRetryContext) {
        boolean shouldRetry;
        boolean bl = shouldRetry = retryPolicy.retryableStatusCode(loadBalancerRetryContext.getResponseStatusCode()) && retryPolicy.canRetryOnMethod(loadBalancerRetryContext.getRequestMethod()) && retryPolicy.canRetrySameServiceInstance(loadBalancerRetryContext);
        if (shouldRetry) {
            loadBalancerRetryContext.incrementRetriesSameServiceInstance();
        }
        return shouldRetry;
    }

    private boolean shouldRetryNextServiceInstance(LoadBalancerRetryPolicy retryPolicy, LoadBalancerRetryContext loadBalancerRetryContext) {
        boolean shouldRetry;
        boolean bl = shouldRetry = retryPolicy.retryableStatusCode(loadBalancerRetryContext.getResponseStatusCode()) && retryPolicy.canRetryOnMethod(loadBalancerRetryContext.getRequestMethod()) && retryPolicy.canRetryNextServiceInstance(loadBalancerRetryContext);
        if (shouldRetry) {
            loadBalancerRetryContext.incrementRetriesNextServiceInstance();
            loadBalancerRetryContext.resetRetriesSameServiceInstance();
        }
        return shouldRetry;
    }

    private boolean isRetryException(Throwable throwable, LoadBalancerRetryPolicy retryPolicy) {
        return retryPolicy.retryableException(throwable) || throwable != null && retryPolicy.retryableException(throwable.getCause()) || Exceptions.isRetryExhausted(throwable);
    }

    protected Mono<Response<ServiceInstance>> choose(String serviceId, Request<RetryableRequestContext> request) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return Mono.just(new EmptyResponse());
        }
        return Mono.from(loadBalancer.choose(request));
    }
}

