/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import org.apache.commons.math.random.MersenneTwister;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.commons.math.random.RandomVectorGenerator;
import org.apache.commons.math.util.FastMath;

public class UnitSphereRandomVectorGenerator
implements RandomVectorGenerator {
    private final RandomGenerator rand;
    private final int dimension;

    public UnitSphereRandomVectorGenerator(int dimension, RandomGenerator rand) {
        this.dimension = dimension;
        this.rand = rand;
    }

    public UnitSphereRandomVectorGenerator(int dimension) {
        this(dimension, new MersenneTwister());
    }

    public double[] nextVector() {
        double normSq;
        double[] v = new double[this.dimension];
        do {
            normSq = 0.0;
            for (int i2 = 0; i2 < this.dimension; ++i2) {
                double comp;
                v[i2] = comp = 2.0 * this.rand.nextDouble() - 1.0;
                normSq += comp * comp;
            }
        } while (normSq > 1.0);
        double f = 1.0 / FastMath.sqrt(normSq);
        int i3 = 0;
        while (i3 < this.dimension) {
            int n = i3++;
            v[n] = v[n] * f;
        }
        return v;
    }
}

