/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.util.TypeUtils;

public class MethodLookupUtils {
    private static final int NO_MATCH = 0;
    private static final int APPROXIMATE_MATCH = 1;
    private static final int EXACT_MATCH = 2;
    static /* synthetic */ Class class$org$apache$commons$jxpath$ExpressionContext;

    public static Constructor lookupConstructor(Class targetClass, Object[] parameters) {
        boolean tryExact = true;
        int count = parameters == null ? 0 : parameters.length;
        Class[] types = new Class[count];
        for (int i2 = 0; i2 < count; ++i2) {
            Object param = parameters[i2];
            if (param != null) {
                types[i2] = param.getClass();
                continue;
            }
            types[i2] = null;
            tryExact = false;
        }
        Constructor<Object> constructor = null;
        if (tryExact) {
            try {
                constructor = targetClass.getConstructor(types);
                if (constructor != null) {
                    return constructor;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Constructor<?>[] constructors = targetClass.getConstructors();
        for (int i3 = 0; i3 < constructors.length; ++i3) {
            int match = MethodLookupUtils.matchParameterTypes(constructors[i3].getParameterTypes(), parameters);
            if (match == 0) continue;
            if (match > currentMatch) {
                constructor = constructors[i3];
                currentMatch = match;
                ambiguous = false;
                continue;
            }
            if (match != currentMatch) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new JXPathException("Ambigous constructor " + Arrays.asList(parameters));
        }
        return constructor;
    }

    public static Method lookupStaticMethod(Class targetClass, String name, Object[] parameters) {
        boolean tryExact = true;
        int count = parameters == null ? 0 : parameters.length;
        Class[] types = new Class[count];
        for (int i2 = 0; i2 < count; ++i2) {
            Object param = parameters[i2];
            if (param != null) {
                types[i2] = param.getClass();
                continue;
            }
            types[i2] = null;
            tryExact = false;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Method[] methods = targetClass.getMethods();
        for (int i3 = 0; i3 < methods.length; ++i3) {
            int match;
            if (!Modifier.isStatic(methods[i3].getModifiers()) || !methods[i3].getName().equals(name) || (match = MethodLookupUtils.matchParameterTypes(methods[i3].getParameterTypes(), parameters)) == 0) continue;
            if (match > currentMatch) {
                method = methods[i3];
                currentMatch = match;
                ambiguous = false;
                continue;
            }
            if (match != currentMatch) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new JXPathException("Ambigous method call: " + name);
        }
        return method;
    }

    public static Method lookupMethod(Class targetClass, String name, Object[] parameters) {
        if (parameters == null || parameters.length < 1 || parameters[0] == null) {
            return null;
        }
        if (MethodLookupUtils.matchType(targetClass, parameters[0]) == 0) {
            return null;
        }
        targetClass = TypeUtils.convert(parameters[0], targetClass).getClass();
        boolean tryExact = true;
        int count = parameters.length - 1;
        Class[] types = new Class[count];
        Object[] arguments = new Object[count];
        for (int i2 = 0; i2 < count; ++i2) {
            Object param;
            arguments[i2] = param = parameters[i2 + 1];
            if (param != null) {
                types[i2] = param.getClass();
                continue;
            }
            types[i2] = null;
            tryExact = false;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && !Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Method[] methods = targetClass.getMethods();
        for (int i3 = 0; i3 < methods.length; ++i3) {
            int match;
            if (Modifier.isStatic(methods[i3].getModifiers()) || !methods[i3].getName().equals(name) || (match = MethodLookupUtils.matchParameterTypes(methods[i3].getParameterTypes(), arguments)) == 0) continue;
            if (match > currentMatch) {
                method = methods[i3];
                currentMatch = match;
                ambiguous = false;
                continue;
            }
            if (match != currentMatch) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new JXPathException("Ambigous method call: " + name);
        }
        return method;
    }

    private static int matchParameterTypes(Class[] types, Object[] parameters) {
        int length;
        int pi = 0;
        if (types.length >= 1 && (class$org$apache$commons$jxpath$ExpressionContext == null ? (class$org$apache$commons$jxpath$ExpressionContext = MethodLookupUtils.class$("org.apache.commons.jxpath.ExpressionContext")) : class$org$apache$commons$jxpath$ExpressionContext).isAssignableFrom(types[0])) {
            ++pi;
        }
        int n = length = parameters == null ? 0 : parameters.length;
        if (types.length != length + pi) {
            return 0;
        }
        int totalMatch = 2;
        for (int i2 = 0; i2 < length; ++i2) {
            int match = MethodLookupUtils.matchType(types[i2 + pi], parameters[i2]);
            if (match == 0) {
                return 0;
            }
            if (match >= totalMatch) continue;
            totalMatch = match;
        }
        return totalMatch;
    }

    private static int matchType(Class expected, Object object) {
        if (object == null) {
            return 1;
        }
        Class<?> actual = object.getClass();
        if (expected.equals(actual)) {
            return 2;
        }
        if (expected.isAssignableFrom(actual)) {
            return 2;
        }
        if (TypeUtils.canConvert(object, expected)) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

