/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.google.common.base.Preconditions;
import com.netflix.infix.ValuePredicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegexValuePredicate
implements ValuePredicate<String> {
    private String regex;
    private Pattern pattern;
    private MatchPolicy policy;

    public RegexValuePredicate(String regex, MatchPolicy policy) {
        Preconditions.checkArgument(regex != null, String.format("The regex should not be null.", new Object[0]));
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
        this.policy = policy;
    }

    @Override
    public boolean apply(@Nullable String input) {
        if (input == null) {
            return false;
        }
        if (this.policy == MatchPolicy.PARTIAL) {
            return this.pattern.matcher(input).find();
        }
        if (this.policy == MatchPolicy.FULL) {
            return this.pattern.matcher(input).matches();
        }
        throw new UnsupportedOperationException(String.format("the match policy %s is not supported", new Object[]{this.policy}));
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public MatchPolicy getMatchPolicy() {
        return this.policy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegexValuePredicate [pattern=");
        builder.append(this.regex);
        builder.append(", policy=");
        builder.append((Object)this.policy);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexValuePredicate other = (RegexValuePredicate)obj;
        if (this.policy != other.policy) {
            return false;
        }
        return !(this.regex == null ? other.regex != null : !this.regex.equals(other.regex));
    }

    public static enum MatchPolicy {
        PARTIAL,
        FULL;

    }
}

