/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.utils;

import com.google.common.base.Preconditions;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.eventbus.impl.EventBatch;
import com.netflix.eventbus.spi.DynamicSubscriber;
import com.netflix.eventbus.spi.EventFilter;
import com.netflix.eventbus.spi.Subscribe;
import com.netflix.eventbus.spi.SubscriberConfigProvider;
import com.netflix.eventbus.spi.SubscriberInfo;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StatsTimer;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.stats.StatsConfig;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.slf4j.Logger;

public class EventBusUtils {
    private static final DynamicIntProperty queueSizeDefault = DynamicPropertyFactory.getInstance().getIntProperty("eventbus.consumer.queue.size.default", 1000);

    public static int getQueueSize(SubscriberConfigProvider.SubscriberConfig subscribe) {
        int queueSize = subscribe.getQueueSize();
        if (queueSize <= 0) {
            queueSize = queueSizeDefault.get();
        }
        return queueSize;
    }

    public static SubscriberConfigProvider.SubscriberConfig getSubscriberConfig(Method subMethod, Object subscriber) {
        Preconditions.checkNotNull(subscriber);
        Preconditions.checkNotNull(subMethod);
        Subscribe annotation = subMethod.getAnnotation(Subscribe.class);
        if (null == annotation) {
            throw new IllegalArgumentException(String.format("Subscriber method %s does not contain a subscriber annotation.", subMethod.toGenericString()));
        }
        SubscriberConfigProvider.SubscriberConfig config = null;
        if (SubscriberConfigProvider.class.isAssignableFrom(subscriber.getClass())) {
            config = ((SubscriberConfigProvider)subscriber).getConfigForName(annotation.name());
        }
        if (null == config) {
            config = new AnnotationBasedSubscriberConfig(annotation);
        }
        return config;
    }

    public static SubscriberConfigProvider.SubscriberConfig getSubscriberConfig(SubscriberInfo subscriberInfo) {
        return EventBusUtils.getSubscriberConfig(subscriberInfo.getSubscriberMethod(), subscriberInfo.getSubscriberInstance());
    }

    public static boolean isAnEventBatch(Object event) {
        return EventBatch.class.isAssignableFrom(event.getClass());
    }

    public static Class<?> getInterestedEventType(Object subscriber, Method subMethod) {
        Class<?> interestedEventType = DynamicSubscriber.class.isAssignableFrom(subscriber.getClass()) ? ((DynamicSubscriber)subscriber).getEventType() : subMethod.getParameterTypes()[0];
        Subscribe annotation = subMethod.getAnnotation(Subscribe.class);
        if (annotation.batchingStrategy() != Subscribe.BatchingStrategy.None && Iterable.class.isAssignableFrom(interestedEventType)) {
            Type[] genericMethodParams = subMethod.getGenericParameterTypes();
            ParameterizedType interestedEventParam = (ParameterizedType)genericMethodParams[0];
            Type[] iterableTypeParams = interestedEventParam.getActualTypeArguments();
            if (iterableTypeParams[0] instanceof ParameterizedType) {
                return (Class)((ParameterizedType)iterableTypeParams[0]).getRawType();
            }
            return (Class)iterableTypeParams[0];
        }
        return interestedEventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean applyFilters(Object event, Set<EventFilter> filters, StatsTimer filterStats, String invokerDesc, Logger logger) {
        if (filters.isEmpty()) {
            return true;
        }
        Stopwatch filterStart = filterStats.start();
        try {
            for (EventFilter filter2 : filters) {
                if (filter2.apply(event)) continue;
                logger.debug("Event: " + event + " filtered out for : " + invokerDesc + " due to the filter: " + filter2);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            filterStart.stop();
        }
    }

    public static StatsTimer newStatsTimer(String monitorName, long collectionDurationInMillis) {
        return new StatsTimer(MonitorConfig.builder(monitorName).build(), new StatsConfig.Builder().withComputeFrequencyMillis(collectionDurationInMillis).withPublishMean(true).withPublishMin(true).withPublishMax(true).withPublishStdDev(true).withPublishVariance(true).build());
    }

    private static class AnnotationBasedSubscriberConfig
    implements SubscriberConfigProvider.SubscriberConfig {
        private final Subscribe annotation;

        public AnnotationBasedSubscriberConfig(Subscribe annotation) {
            this.annotation = annotation;
        }

        @Override
        public Subscribe.BatchingStrategy getBatchingStrategy() {
            return this.annotation.batchingStrategy();
        }

        @Override
        public int getBatchAge() {
            return this.annotation.batchAge();
        }

        @Override
        public int getBatchSize() {
            return this.annotation.batchSize();
        }

        @Override
        public int getQueueSize() {
            return this.annotation.queueSize();
        }

        @Override
        public boolean syncIfAllowed() {
            return this.annotation.syncIfAllowed();
        }
    }
}

