/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializerStringCache
implements Function<String, String> {
    private static final Logger logger = LoggerFactory.getLogger(DeserializerStringCache.class);
    private static final boolean debugLogEnabled = logger.isDebugEnabled();
    private static final String ATTR_STRING_CACHE = "deserInternCache";
    private static final int LENGTH_LIMIT = 256;
    private static final int LRU_LIMIT = 40960;
    private final Map<CharBuffer, String> globalCache;
    private final Map<CharBuffer, String> applicationCache;
    private final int lengthLimit = 256;

    public static ObjectReader init(ObjectReader reader) {
        return reader.withAttribute(ATTR_STRING_CACHE, new DeserializerStringCache(new HashMap<CharBuffer, String>(2048), (Map<CharBuffer, String>)new LinkedHashMap<CharBuffer, String>(4096, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<CharBuffer, String> eldest) {
                return this.size() > 40960;
            }
        }));
    }

    public static ObjectReader init(ObjectReader reader, DeserializationContext context) {
        return DeserializerStringCache.withCache(context, (DeserializerStringCache cache) -> {
            if (cache == null) {
                throw new IllegalStateException();
            }
            return reader.withAttribute(ATTR_STRING_CACHE, cache);
        });
    }

    public static DeserializerStringCache from(DeserializationContext context) {
        return DeserializerStringCache.withCache(context, (DeserializerStringCache cache) -> {
            if (cache == null) {
                cache = new DeserializerStringCache(new HashMap<CharBuffer, String>(), new HashMap<CharBuffer, String>());
            }
            return cache;
        });
    }

    public static void clear(ObjectReader reader) {
        DeserializerStringCache.clear(reader, CacheScope.APPLICATION_SCOPE);
    }

    public static void clear(ObjectReader reader, CacheScope scope) {
        DeserializerStringCache.withCache(reader, (DeserializerStringCache cache) -> {
            if (scope == CacheScope.GLOBAL_SCOPE) {
                if (debugLogEnabled) {
                    logger.debug("clearing global-level cache with size {}", (Object)cache.globalCache.size());
                }
                cache.globalCache.clear();
            }
            if (debugLogEnabled) {
                logger.debug("clearing app-level serialization cache with size {}", (Object)cache.applicationCache.size());
            }
            cache.applicationCache.clear();
            return null;
        });
    }

    public static void clear(DeserializationContext context) {
        DeserializerStringCache.clear(context, CacheScope.APPLICATION_SCOPE);
    }

    public static void clear(DeserializationContext context, CacheScope scope) {
        DeserializerStringCache.withCache(context, (DeserializerStringCache cache) -> {
            if (scope == CacheScope.GLOBAL_SCOPE) {
                if (debugLogEnabled) {
                    logger.debug("clearing global-level serialization cache with size {}", (Object)cache.globalCache.size());
                }
                cache.globalCache.clear();
            }
            if (debugLogEnabled) {
                logger.debug("clearing app-level serialization cache with size {}", (Object)cache.applicationCache.size());
            }
            cache.applicationCache.clear();
            return null;
        });
    }

    private static <T> T withCache(DeserializationContext context, Function<DeserializerStringCache, T> consumer) {
        DeserializerStringCache cache = (DeserializerStringCache)context.getAttribute(ATTR_STRING_CACHE);
        return consumer.apply(cache);
    }

    private static <T> T withCache(ObjectReader reader, Function<DeserializerStringCache, T> consumer) {
        DeserializerStringCache cache = (DeserializerStringCache)reader.getAttributes().getAttribute(ATTR_STRING_CACHE);
        return consumer.apply(cache);
    }

    private DeserializerStringCache(Map<CharBuffer, String> globalCache, Map<CharBuffer, String> applicationCache) {
        this.globalCache = globalCache;
        this.applicationCache = applicationCache;
    }

    public ObjectReader initReader(ObjectReader reader) {
        return reader.withAttribute(ATTR_STRING_CACHE, this);
    }

    @Override
    public String apply(JsonParser jp) throws IOException {
        return this.apply(jp, CacheScope.APPLICATION_SCOPE, null);
    }

    public String apply(JsonParser jp, CacheScope cacheScope) throws IOException {
        return this.apply(jp, cacheScope, null);
    }

    public String apply(JsonParser jp, CacheScope cacheScope, Supplier<String> source) throws IOException {
        return this.apply(CharBuffer.wrap(jp, source), cacheScope);
    }

    @Override
    public String apply(CharBuffer charValue) {
        return this.apply(charValue, CacheScope.APPLICATION_SCOPE);
    }

    public String apply(CharBuffer charValue, CacheScope cacheScope) {
        int keyLength = charValue.length();
        if (keyLength <= 256) {
            Map<CharBuffer, String> cache = cacheScope == CacheScope.GLOBAL_SCOPE ? this.globalCache : this.applicationCache;
            String value = cache.get(charValue);
            if (value == null) {
                value = charValue.consume((k, v) -> cache.put((CharBuffer)k, (String)v));
            }
            return value;
        }
        return charValue.toString();
    }

    @Override
    public String apply(String stringValue) {
        return this.apply(stringValue, CacheScope.APPLICATION_SCOPE);
    }

    public String apply(String stringValue, CacheScope cacheScope) {
        if (stringValue != null && stringValue.length() <= 256) {
            return (cacheScope == CacheScope.GLOBAL_SCOPE ? this.globalCache : this.applicationCache).computeIfAbsent(CharBuffer.wrap(stringValue), s -> {
                logger.trace(" (string) writing new interned value {} into {} cache scope", (Object)stringValue, (Object)cacheScope);
                return stringValue;
            });
        }
        return stringValue;
    }

    public int size() {
        return this.globalCache.size() + this.applicationCache.size();
    }

    private static interface CharBuffer {
        public static final int DEFAULT_VARIANT = -1;

        public static CharBuffer wrap(JsonParser source, Supplier<String> stringSource) throws IOException {
            return new ArrayCharBuffer(source, stringSource);
        }

        public static CharBuffer wrap(JsonParser source) throws IOException {
            return new ArrayCharBuffer(source);
        }

        public static CharBuffer wrap(String source) {
            return new StringCharBuffer(source);
        }

        public String consume(BiConsumer<CharBuffer, String> var1);

        public int length();

        public int variant();

        public PrimitiveIterator.OfInt chars();

        public static class StringCharBuffer
        implements CharBuffer {
            private final String source;
            private final int variant;
            private final int hashCode;

            StringCharBuffer(String source) {
                this(source, -1);
            }

            StringCharBuffer(String source, int variant) {
                this.source = source;
                this.variant = variant;
                this.hashCode = 31 * source.hashCode() + variant;
            }

            public int hashCode() {
                return this.hashCode;
            }

            @Override
            public int variant() {
                return this.variant;
            }

            public boolean equals(Object other) {
                CharBuffer otherBuffer;
                if (other instanceof CharBuffer && (otherBuffer = (CharBuffer)other).variant() == this.variant) {
                    int length = this.source.length();
                    if (otherBuffer.length() == length) {
                        PrimitiveIterator.OfInt otherText = otherBuffer.chars();
                        for (int i2 = 0; i2 < length; ++i2) {
                            if (this.source.charAt(i2) == otherText.nextInt()) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int length() {
                return this.source.length();
            }

            public String toString() {
                return this.source;
            }

            @Override
            public PrimitiveIterator.OfInt chars() {
                return new PrimitiveIterator.OfInt(){
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < source.length();
                    }

                    @Override
                    public int nextInt() {
                        return source.charAt(this.index++);
                    }
                };
            }

            @Override
            public String consume(BiConsumer<CharBuffer, String> valueConsumer) {
                valueConsumer.accept(this, this.source);
                return this.source;
            }
        }

        public static class ArrayCharBuffer
        implements CharBuffer {
            private final char[] source;
            private final int offset;
            private final int length;
            private final Supplier<String> valueTransform;
            private final int variant;
            private final int hash;

            ArrayCharBuffer(JsonParser source) throws IOException {
                this(source, null);
            }

            ArrayCharBuffer(JsonParser source, Supplier<String> valueTransform) throws IOException {
                this.source = source.getTextCharacters();
                this.offset = source.getTextOffset();
                this.length = source.getTextLength();
                this.valueTransform = valueTransform;
                this.variant = valueTransform == null ? -1 : System.identityHashCode(valueTransform.getClass());
                this.hash = 31 * ArrayCharBuffer.arrayHash(this.source, this.offset, this.length) + this.variant;
            }

            @Override
            public int length() {
                return this.length;
            }

            @Override
            public int variant() {
                return this.variant;
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object other) {
                CharBuffer otherBuffer;
                if (other instanceof CharBuffer && (otherBuffer = (CharBuffer)other).length() == this.length && otherBuffer.variant() == this.variant) {
                    PrimitiveIterator.OfInt otherText = otherBuffer.chars();
                    for (int i2 = this.offset; i2 < this.length; ++i2) {
                        if (this.source[i2] == otherText.nextInt()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public PrimitiveIterator.OfInt chars() {
                return new PrimitiveIterator.OfInt(){
                    int index;
                    int limit;
                    {
                        this.index = offset;
                        this.limit = this.index + length;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.limit;
                    }

                    @Override
                    public int nextInt() {
                        return source[this.index++];
                    }
                };
            }

            public String toString() {
                return this.valueTransform == null ? new String(this.source, this.offset, this.length) : this.valueTransform.get();
            }

            @Override
            public String consume(BiConsumer<CharBuffer, String> valueConsumer) {
                String key = new String(this.source, this.offset, this.length);
                String value = this.valueTransform == null ? key : this.valueTransform.get();
                valueConsumer.accept(new StringCharBuffer(key, this.variant), value);
                return value;
            }

            private static int arrayHash(char[] a, int offset, int length) {
                if (a == null) {
                    return 0;
                }
                int result = 0;
                int limit = offset + length;
                for (int i2 = offset; i2 < limit; ++i2) {
                    result = 31 * result + a[i2];
                }
                return result;
            }
        }
    }

    public static enum CacheScope {
        APPLICATION_SCOPE,
        GLOBAL_SCOPE;

    }
}

