/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.decorator;

import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.TransportUtils;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionedEurekaHttpClient
extends EurekaHttpClientDecorator {
    private static final Logger logger = LoggerFactory.getLogger(SessionedEurekaHttpClient.class);
    private final Random random = new Random();
    private final String name;
    private final EurekaHttpClientFactory clientFactory;
    private final long sessionDurationMs;
    private volatile long currentSessionDurationMs;
    private volatile long lastReconnectTimeStamp = -1L;
    private final AtomicReference<EurekaHttpClient> eurekaHttpClientRef = new AtomicReference();

    public SessionedEurekaHttpClient(String name, EurekaHttpClientFactory clientFactory, long sessionDurationMs) {
        this.name = name;
        this.clientFactory = clientFactory;
        this.sessionDurationMs = sessionDurationMs;
        this.currentSessionDurationMs = this.randomizeSessionDuration(sessionDurationMs);
        Monitors.registerObject(name, this);
    }

    @Override
    protected <R> EurekaHttpResponse<R> execute(EurekaHttpClientDecorator.RequestExecutor<R> requestExecutor) {
        EurekaHttpClient eurekaHttpClient;
        long now = System.currentTimeMillis();
        long delay = now - this.lastReconnectTimeStamp;
        if (delay >= this.currentSessionDurationMs) {
            logger.debug("Ending a session and starting anew");
            this.lastReconnectTimeStamp = now;
            this.currentSessionDurationMs = this.randomizeSessionDuration(this.sessionDurationMs);
            TransportUtils.shutdown(this.eurekaHttpClientRef.getAndSet(null));
        }
        if ((eurekaHttpClient = this.eurekaHttpClientRef.get()) == null) {
            eurekaHttpClient = TransportUtils.getOrSetAnotherClient(this.eurekaHttpClientRef, this.clientFactory.newClient());
        }
        return requestExecutor.execute(eurekaHttpClient);
    }

    @Override
    public void shutdown() {
        if (Monitors.isObjectRegistered(this.name, this)) {
            Monitors.unregisterObject(this.name, this);
        }
        TransportUtils.shutdown(this.eurekaHttpClientRef.getAndSet(null));
    }

    protected long randomizeSessionDuration(long sessionDurationMs) {
        long delta = (long)((double)sessionDurationMs * (this.random.nextDouble() - 0.5));
        return sessionDurationMs + delta;
    }

    @Monitor(name="eurekaClient.transport.currentSessionDuration", description="Duration of the current session", type=DataSourceType.GAUGE)
    public long getCurrentSessionDuration() {
        return this.lastReconnectTimeStamp < 0L ? 0L : System.currentTimeMillis() - this.lastReconnectTimeStamp;
    }
}

