/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.netflix.appinfo.InstanceInfo;
import java.io.IOException;

public class PortWrapperXmlDeserializer
extends StdDeserializer<InstanceInfo.PortWrapper> {
    public PortWrapperXmlDeserializer() {
        super(InstanceInfo.PortWrapper.class);
    }

    @Override
    public InstanceInfo.PortWrapper deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        boolean enabled = false;
        int port = 0;
        while (jp.nextToken() == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("enabled".equals(fieldName)) {
                enabled = Boolean.valueOf(jp.getValueAsString());
                continue;
            }
            if (fieldName == null || "".equals(fieldName)) {
                String value = jp.getValueAsString();
                port = value == null ? 0 : Integer.parseInt(value);
                continue;
            }
            throw new JsonMappingException("Unexpected field " + fieldName, jp.getCurrentLocation());
        }
        return new InstanceInfo.PortWrapper(enabled, port);
    }
}

