/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import com.netflix.appinfo.InstanceInfo;
import java.io.IOException;

public class InstanceInfoXmlBeanSerializer
extends XmlBeanSerializer {
    public InstanceInfoXmlBeanSerializer(BeanSerializerBase src) {
        super(src);
    }

    protected void serializeFields(Object bean2, JsonGenerator jgen0, SerializerProvider provider) throws IOException {
        super.serializeFields(bean2, jgen0, provider);
        InstanceInfo instanceInfo = (InstanceInfo)bean2;
        ToXmlGenerator xgen = (ToXmlGenerator)jgen0;
        xgen.writeFieldName("port");
        xgen.writeStartObject();
        xgen.setNextIsAttribute(true);
        xgen.writeFieldName("enabled");
        xgen.writeBoolean(instanceInfo.isPortEnabled(InstanceInfo.PortType.UNSECURE));
        xgen.setNextIsAttribute(false);
        xgen.writeFieldName("port");
        xgen.setNextIsUnwrapped(true);
        xgen.writeString(Integer.toString(instanceInfo.getPort()));
        xgen.writeEndObject();
        xgen.writeFieldName("securePort");
        xgen.writeStartObject();
        xgen.setNextIsAttribute(true);
        xgen.writeStringField("enabled", Boolean.toString(instanceInfo.isPortEnabled(InstanceInfo.PortType.SECURE)));
        xgen.setNextIsAttribute(false);
        xgen.writeFieldName("securePort");
        xgen.setNextIsUnwrapped(true);
        xgen.writeString(Integer.toString(instanceInfo.getSecurePort()));
        xgen.writeEndObject();
    }
}

