/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedSupervisorTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(TimedSupervisorTask.class);
    private final Counter successCounter;
    private final Counter timeoutCounter;
    private final Counter rejectedCounter;
    private final Counter throwableCounter;
    private final LongGauge threadPoolLevelGauge;
    private final String name;
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor executor;
    private final long timeoutMillis;
    private final Runnable task;
    private final AtomicLong delay;
    private final long maxDelay;

    public TimedSupervisorTask(String name, ScheduledExecutorService scheduler, ThreadPoolExecutor executor, int timeout, TimeUnit timeUnit, int expBackOffBound, Runnable task) {
        this.name = name;
        this.scheduler = scheduler;
        this.executor = executor;
        this.timeoutMillis = timeUnit.toMillis(timeout);
        this.task = task;
        this.delay = new AtomicLong(this.timeoutMillis);
        this.maxDelay = this.timeoutMillis * (long)expBackOffBound;
        this.successCounter = Monitors.newCounter("success");
        this.timeoutCounter = Monitors.newCounter("timeouts");
        this.rejectedCounter = Monitors.newCounter("rejectedExecutions");
        this.throwableCounter = Monitors.newCounter("throwables");
        this.threadPoolLevelGauge = new LongGauge(MonitorConfig.builder("threadPoolUsed").build());
        Monitors.registerObject(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Future<?> future = null;
        try {
            future = this.executor.submit(this.task);
            this.threadPoolLevelGauge.set(Long.valueOf(this.executor.getActiveCount()));
            future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            this.delay.set(this.timeoutMillis);
            this.threadPoolLevelGauge.set(Long.valueOf(this.executor.getActiveCount()));
            this.successCounter.increment();
        }
        catch (TimeoutException e) {
            logger.warn("task supervisor timed out", e);
            this.timeoutCounter.increment();
            long currentDelay = this.delay.get();
            long newDelay = Math.min(this.maxDelay, currentDelay * 2L);
            this.delay.compareAndSet(currentDelay, newDelay);
        }
        catch (RejectedExecutionException e) {
            if (this.executor.isShutdown() || this.scheduler.isShutdown()) {
                logger.warn("task supervisor shutting down, reject the task", e);
            } else {
                logger.warn("task supervisor rejected the task", e);
            }
            this.rejectedCounter.increment();
        }
        catch (Throwable e) {
            if (this.executor.isShutdown() || this.scheduler.isShutdown()) {
                logger.warn("task supervisor shutting down, can't accept the task");
            } else {
                logger.warn("task supervisor threw an exception", e);
            }
            this.throwableCounter.increment();
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            if (!this.scheduler.isShutdown()) {
                this.scheduler.schedule(this, this.delay.get(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public boolean cancel() {
        Monitors.unregisterObject(this.name, this);
        return super.cancel();
    }
}

