/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.net.SocketAddress;
import reactor.netty.Metrics;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.resources.ConnectionProviderMeters;

final class MicrometerPooledConnectionProviderMeterRegistrar {
    static final MicrometerPooledConnectionProviderMeterRegistrar INSTANCE = new MicrometerPooledConnectionProviderMeterRegistrar();

    private MicrometerPooledConnectionProviderMeterRegistrar() {
    }

    void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of(ConnectionProviderMeters.ConnectionProviderMetersTags.ID.asString(), id, ConnectionProviderMeters.ConnectionProviderMetersTags.REMOTE_ADDRESS.asString(), addressAsString, ConnectionProviderMeters.ConnectionProviderMetersTags.NAME.asString(), poolName);
        Gauge.builder(ConnectionProviderMeters.TOTAL_CONNECTIONS.getName(), metrics, InstrumentedPool.PoolMetrics::allocatedSize).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder(ConnectionProviderMeters.ACTIVE_CONNECTIONS.getName(), metrics, InstrumentedPool.PoolMetrics::acquiredSize).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder(ConnectionProviderMeters.IDLE_CONNECTIONS.getName(), metrics, InstrumentedPool.PoolMetrics::idleSize).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder(ConnectionProviderMeters.PENDING_CONNECTIONS.getName(), metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder(ConnectionProviderMeters.MAX_CONNECTIONS.getName(), metrics, InstrumentedPool.PoolMetrics::getMaxAllocatedSize).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder(ConnectionProviderMeters.MAX_PENDING_CONNECTIONS.getName(), metrics, InstrumentedPool.PoolMetrics::getMaxPendingAcquireSize).tags(tags).register(Metrics.REGISTRY);
    }

    void deRegisterMetrics(String poolName, String id, SocketAddress remoteAddress) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of(ConnectionProviderMeters.ConnectionProviderMetersTags.ID.asString(), id, ConnectionProviderMeters.ConnectionProviderMetersTags.REMOTE_ADDRESS.asString(), addressAsString, ConnectionProviderMeters.ConnectionProviderMetersTags.NAME.asString(), poolName);
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.TOTAL_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.ACTIVE_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.IDLE_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.PENDING_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.MAX_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(ConnectionProviderMeters.MAX_PENDING_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
    }
}

