/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import reactor.core.Disposable;
import reactor.netty.Metrics;
import reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;
import reactor.netty.resources.ConnectionProviderMeters;

final class MicrometerPoolMetricsRecorder
implements Disposable,
PoolMetricsRecorder {
    final Timer pendingSuccessTimer;
    final Timer pendingErrorTimer;

    MicrometerPoolMetricsRecorder(String id, String poolName, SocketAddress remoteAddress) {
        this.pendingSuccessTimer = MicrometerPoolMetricsRecorder.buildTimer(id, poolName, remoteAddress, "SUCCESS");
        this.pendingErrorTimer = MicrometerPoolMetricsRecorder.buildTimer(id, poolName, remoteAddress, "ERROR");
    }

    @Override
    public void recordAllocationSuccessAndLatency(long latencyMs) {
    }

    @Override
    public void recordAllocationFailureAndLatency(long latencyMs) {
    }

    @Override
    public void recordResetLatency(long latencyMs) {
    }

    @Override
    public void recordDestroyLatency(long latencyMs) {
    }

    @Override
    public void recordRecycled() {
    }

    @Override
    public void recordLifetimeDuration(long millisecondsSinceAllocation) {
    }

    @Override
    public void recordIdleTime(long millisecondsIdle) {
    }

    @Override
    public void recordSlowPath() {
    }

    @Override
    public void recordFastPath() {
    }

    @Override
    public void recordPendingSuccessAndLatency(long latencyMs) {
        this.pendingSuccessTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void recordPendingFailureAndLatency(long latencyMs) {
        this.pendingErrorTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void dispose() {
        Metrics.REGISTRY.remove(this.pendingSuccessTimer);
        Metrics.REGISTRY.remove(this.pendingErrorTimer);
    }

    static Timer buildTimer(String id, String poolName, SocketAddress remoteAddress, String status) {
        return ((Timer.Builder)Timer.builder(ConnectionProviderMeters.PENDING_CONNECTIONS_TIME.getName()).tags((Iterable)Tags.of(ConnectionProviderMeters.PendingConnectionsTimeTags.ID.asString(), id, ConnectionProviderMeters.PendingConnectionsTimeTags.REMOTE_ADDRESS.asString(), Metrics.formatSocketAddress(remoteAddress), ConnectionProviderMeters.PendingConnectionsTimeTags.NAME.asString(), poolName, ConnectionProviderMeters.PendingConnectionsTimeTags.STATUS.asString(), status))).register(Metrics.REGISTRY);
    }
}

