/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.DispatchExceptionHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.ControllerMethodResolver;
import org.springframework.web.reactive.result.method.annotation.InitBinderBindingContext;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.DisconnectedClientHelper;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class RequestMappingHandlerAdapter
implements HandlerAdapter,
DispatchExceptionHandler,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RequestMappingHandlerAdapter.class);
    private static final String DISCONNECTED_CLIENT_LOG_CATEGORY = "org.springframework.web.reactive.result.method.annotation.DisconnectedClient";
    private static final DisconnectedClientHelper disconnectedClientHelper = new DisconnectedClientHelper("org.springframework.web.reactive.result.method.annotation.DisconnectedClient");
    private List<HttpMessageReader<?>> messageReaders = Collections.emptyList();
    @Nullable
    private WebBindingInitializer webBindingInitializer;
    @Nullable
    private ArgumentResolverConfigurer argumentResolverConfigurer;
    @Nullable
    private Scheduler scheduler;
    @Nullable
    private Predicate<HandlerMethod> blockingMethodPredicate;
    @Nullable
    private ReactiveAdapterRegistry reactiveAdapterRegistry;
    @Nullable
    private ConfigurableApplicationContext applicationContext;
    @Nullable
    private ControllerMethodResolver methodResolver;
    @Nullable
    private ModelInitializer modelInitializer;

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        Assert.notNull(messageReaders, "'messageReaders' must not be null");
        this.messageReaders = messageReaders;
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    public void setWebBindingInitializer(@Nullable WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    @Nullable
    public WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public void setArgumentResolverConfigurer(@Nullable ArgumentResolverConfigurer configurer) {
        this.argumentResolverConfigurer = configurer;
    }

    @Nullable
    public ArgumentResolverConfigurer getArgumentResolverConfigurer() {
        return this.argumentResolverConfigurer;
    }

    public void setBlockingExecutor(@Nullable Executor executor) {
        this.scheduler = executor != null ? Schedulers.fromExecutor(executor) : null;
    }

    public void setBlockingMethodPredicate(Predicate<HandlerMethod> predicate) {
        this.blockingMethodPredicate = predicate;
    }

    public void setReactiveAdapterRegistry(@Nullable ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    @Nullable
    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac;
            this.applicationContext = cac = (ConfigurableApplicationContext)applicationContext;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, "ApplicationContext is required");
        if (CollectionUtils.isEmpty(this.messageReaders)) {
            ServerCodecConfigurer codecConfigurer = ServerCodecConfigurer.create();
            this.messageReaders = codecConfigurer.getReaders();
        }
        if (this.argumentResolverConfigurer == null) {
            this.argumentResolverConfigurer = new ArgumentResolverConfigurer();
        }
        if (this.reactiveAdapterRegistry == null) {
            this.reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
        }
        if (this.scheduler != null && this.blockingMethodPredicate == null) {
            this.blockingMethodPredicate = new NonReactiveHandlerMethodPredicate(this.reactiveAdapterRegistry);
        }
        this.methodResolver = new ControllerMethodResolver(this.argumentResolverConfigurer, this.reactiveAdapterRegistry, this.applicationContext, this.messageReaders, this.webBindingInitializer, this.scheduler, this.blockingMethodPredicate);
        this.modelInitializer = new ModelInitializer(this.methodResolver, this.reactiveAdapterRegistry);
    }

    @Override
    public boolean supports(Object handler) {
        return handler instanceof HandlerMethod;
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange2, Object handler) {
        Assert.state(this.methodResolver != null && this.modelInitializer != null && this.reactiveAdapterRegistry != null, "Not initialized");
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        InitBinderBindingContext bindingContext = new InitBinderBindingContext(this.webBindingInitializer, this.methodResolver.getInitBinderMethods(handlerMethod), this.methodResolver.hasMethodValidator() && handlerMethod.shouldValidateArguments(), this.reactiveAdapterRegistry);
        InvocableHandlerMethod invocableMethod = this.methodResolver.getRequestMappingMethod(handlerMethod);
        DispatchExceptionHandler exceptionHandler = (exchange22, ex) -> this.handleException(exchange2, ex, handlerMethod, bindingContext);
        Mono<HandlerResult> resultMono = this.modelInitializer.initModel(handlerMethod, bindingContext, exchange2).then(Mono.defer(() -> invocableMethod.invoke(exchange2, bindingContext, new Object[0]))).doOnNext(result -> result.setExceptionHandler(exceptionHandler)).onErrorResume(ex -> exceptionHandler.handleError(exchange2, (Throwable)ex));
        Scheduler optionalScheduler = this.methodResolver.getSchedulerFor(handlerMethod);
        if (optionalScheduler != null) {
            return resultMono.subscribeOn(optionalScheduler);
        }
        return resultMono;
    }

    private Mono<HandlerResult> handleException(ServerWebExchange exchange2, Throwable exception, @Nullable HandlerMethod handlerMethod, @Nullable BindingContext bindingContext) {
        Assert.state(this.methodResolver != null, "Not initialized");
        exchange2.getAttributes().remove(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        exchange2.getResponse().getHeaders().clearContentHeaders();
        InvocableHandlerMethod invocable = this.methodResolver.getExceptionHandlerMethod(exception, handlerMethod);
        if (invocable != null) {
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(exchange2.getLogPrefix() + "Using @ExceptionHandler " + invocable);
                }
                if (bindingContext != null) {
                    bindingContext.getModel().asMap().clear();
                } else {
                    bindingContext = new BindingContext();
                }
                Throwable exToExpose = exception;
                while (exToExpose != null) {
                    exceptions.add(exToExpose);
                    Throwable cause = exToExpose.getCause();
                    exToExpose = cause != exToExpose ? cause : null;
                }
                Object[] arguments = new Object[exceptions.size() + 1];
                exceptions.toArray(arguments);
                arguments[arguments.length - 1] = handlerMethod;
                return invocable.invoke(exchange2, bindingContext, arguments).onErrorResume(invocationEx -> RequestMappingHandlerAdapter.handleExceptionHandlerFailure(exchange2, exception, invocationEx, exceptions, invocable));
            }
            catch (Throwable invocationEx2) {
                return RequestMappingHandlerAdapter.handleExceptionHandlerFailure(exchange2, exception, invocationEx2, exceptions, invocable);
            }
        }
        return Mono.error(exception);
    }

    private static Mono<HandlerResult> handleExceptionHandlerFailure(ServerWebExchange exchange2, Throwable exception, Throwable invocationEx, ArrayList<Throwable> exceptions, InvocableHandlerMethod invocable) {
        if (disconnectedClientHelper.checkAndLogClientDisconnectedException(invocationEx)) {
            return Mono.empty();
        }
        if (!exceptions.contains(invocationEx) && logger.isWarnEnabled()) {
            logger.warn(exchange2.getLogPrefix() + "Failure in @ExceptionHandler " + invocable, invocationEx);
        }
        return Mono.error(exception);
    }

    @Override
    public Mono<HandlerResult> handleError(ServerWebExchange exchange2, Throwable ex) {
        return this.handleException(exchange2, ex, null, null);
    }

    private record NonReactiveHandlerMethodPredicate(ReactiveAdapterRegistry adapterRegistry) implements Predicate<HandlerMethod>
    {
        @Override
        public boolean test(HandlerMethod handlerMethod) {
            Class<?> returnType = handlerMethod.getReturnType().getParameterType();
            return this.adapterRegistry.getAdapter(returnType) == null && !KotlinDetector.isSuspendingFunction(handlerMethod.getMethod());
        }
    }
}

