/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.Conventions;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ControllerMethodResolver;
import org.springframework.web.reactive.result.method.annotation.InitBinderBindingContext;
import org.springframework.web.reactive.result.method.annotation.SessionAttributesHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

class ModelInitializer {
    private final ControllerMethodResolver methodResolver;
    private final ReactiveAdapterRegistry adapterRegistry;

    public ModelInitializer(ControllerMethodResolver methodResolver, ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)methodResolver, "ControllerMethodResolver is required");
        Assert.notNull((Object)adapterRegistry, "ReactiveAdapterRegistry is required");
        this.methodResolver = methodResolver;
        this.adapterRegistry = adapterRegistry;
    }

    public Mono<Void> initModel(HandlerMethod handlerMethod, InitBinderBindingContext bindingContext, ServerWebExchange exchange2) {
        List<InvocableHandlerMethod> modelMethods = this.methodResolver.getModelAttributeMethods(handlerMethod);
        SessionAttributesHandler sessionAttributesHandler = this.methodResolver.getSessionAttributesHandler(handlerMethod);
        if (!sessionAttributesHandler.hasSessionAttributes()) {
            return this.invokeModelAttributeMethods(bindingContext, modelMethods, exchange2);
        }
        return exchange2.getSession().flatMap(session -> {
            Map<String, Object> attributes = sessionAttributesHandler.retrieveAttributes((WebSession)session);
            bindingContext.getModel().mergeAttributes(attributes);
            bindingContext.setSessionContext(sessionAttributesHandler, (WebSession)session);
            return this.invokeModelAttributeMethods(bindingContext, modelMethods, exchange2).doOnSuccess(aVoid -> this.findModelAttributes(handlerMethod, sessionAttributesHandler).forEach(name -> {
                if (!bindingContext.getModel().containsAttribute((String)name)) {
                    Object value = session.getRequiredAttribute((String)name);
                    bindingContext.getModel().addAttribute((String)name, value);
                }
            }));
        });
    }

    private Mono<Void> invokeModelAttributeMethods(BindingContext bindingContext, List<InvocableHandlerMethod> modelMethods, ServerWebExchange exchange2) {
        ArrayList resultList = new ArrayList();
        modelMethods.forEach(invocable -> resultList.add(invocable.invoke(exchange2, bindingContext, new Object[0])));
        return Mono.zip(resultList, objectArray -> Arrays.stream(objectArray).map(object -> this.handleResult((HandlerResult)object, bindingContext)).toList()).flatMap(Mono::when);
    }

    private Mono<Void> handleResult(HandlerResult handlerResult, BindingContext bindingContext) {
        Object value = handlerResult.getReturnValue();
        if (value != null) {
            ResolvableType type = handlerResult.getReturnType();
            MethodParameter typeSource = handlerResult.getReturnTypeSource();
            ReactiveAdapter adapter = this.adapterRegistry.getAdapter(type.resolve(), value);
            if (adapter != null && this.isAsyncVoidType(type, typeSource, adapter)) {
                return Mono.from(adapter.toPublisher(value));
            }
            String name = this.getAttributeName(typeSource);
            bindingContext.getModel().asMap().putIfAbsent(name, value);
        }
        return Mono.empty();
    }

    private boolean isAsyncVoidType(ResolvableType type, MethodParameter typeSource, ReactiveAdapter adapter) {
        Method method = typeSource.getMethod();
        return adapter.isNoValue() || type.resolveGeneric(new int[0]) == Void.class || method != null && KotlinDetector.isSuspendingFunction(method) && typeSource.getParameterType() == Void.TYPE;
    }

    private String getAttributeName(MethodParameter param) {
        return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(param.getAnnotatedElement(), ModelAttribute.class)).filter(ann -> StringUtils.hasText(ann.value())).map(ModelAttribute::value).orElseGet(() -> Conventions.getVariableNameForParameter(param));
    }

    private List<String> findModelAttributes(HandlerMethod handlerMethod, SessionAttributesHandler sessionAttributesHandler) {
        ArrayList<String> result = new ArrayList<String>();
        for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
            Class<?> paramType;
            String name;
            if (!parameter.hasParameterAnnotation(ModelAttribute.class) || !sessionAttributesHandler.isHandlerSessionAttribute(name = ModelInitializer.getNameForParameter(parameter), paramType = parameter.getParameterType())) continue;
            result.add(name);
        }
        return result;
    }

    public static String getNameForParameter(MethodParameter parameter) {
        ModelAttribute ann = parameter.getParameterAnnotation(ModelAttribute.class);
        String name = ann != null ? ann.value() : null;
        return StringUtils.hasText(name) ? name : Conventions.getVariableNameForParameter(parameter);
    }
}

