/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.scheduling.quartz.DelegatingJob;
import org.springframework.util.ReflectionUtils;

public class AdaptableJobFactory
implements JobFactory {
    public Job newJob(TriggerFiredBundle bundle2, Scheduler scheduler) throws SchedulerException {
        try {
            Object jobObject = this.createJobInstance(bundle2);
            return this.adaptJob(jobObject);
        }
        catch (Throwable ex) {
            throw new SchedulerException("Job instantiation failed", ex);
        }
    }

    protected Object createJobInstance(TriggerFiredBundle bundle2) throws Exception {
        Class jobClass = bundle2.getJobDetail().getJobClass();
        return ReflectionUtils.accessibleConstructor(jobClass, new Class[0]).newInstance(new Object[0]);
    }

    protected Job adaptJob(Object jobObject) throws Exception {
        if (jobObject instanceof Job) {
            Job job = (Job)jobObject;
            return job;
        }
        if (jobObject instanceof Runnable) {
            Runnable runnable = (Runnable)jobObject;
            return new DelegatingJob(runnable);
        }
        throw new IllegalArgumentException("Unable to execute job class [" + jobObject.getClass().getName() + "]: only [org.quartz.Job] and [java.lang.Runnable] supported.");
    }
}

