/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.jackson.mixin.ApplicationsJsonMixIn;
import com.netflix.discovery.converters.jackson.mixin.InstanceInfoJsonMixIn;
import com.netflix.discovery.converters.jackson.serializer.InstanceInfoJsonBeanSerializer;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.springframework.cloud.netflix.eureka.http.WebClientEurekaHttpClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunctions;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebClientTransportClientFactory
implements TransportClientFactory {
    private final Supplier<WebClient.Builder> builderSupplier;

    public WebClientTransportClientFactory(Supplier<WebClient.Builder> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    @Override
    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        WebClient.Builder builder = this.builderSupplier.get().clone();
        this.setUrl(builder, endpoint.getServiceUrl());
        this.setCodecs(builder);
        builder.filter(this.http4XxErrorExchangeFilterFunction());
        return new WebClientEurekaHttpClient(builder.build());
    }

    private WebClient.Builder setUrl(WebClient.Builder builder, String serviceUrl) {
        String url = serviceUrl;
        try {
            String[] credentials;
            URI serviceURI = new URI(serviceUrl);
            if (serviceURI.getUserInfo() != null && (credentials = serviceURI.getUserInfo().split(":")).length == 2) {
                builder.filter(ExchangeFilterFunctions.basicAuthentication(credentials[0], credentials[1]));
                url = serviceUrl.replace(credentials[0] + ":" + credentials[1] + "@", "");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return builder.baseUrl(url);
    }

    private static BeanSerializerModifier createJsonSerializerModifier() {
        return new BeanSerializerModifier(){

            @Override
            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (beanDesc.getBeanClass().isAssignableFrom(InstanceInfo.class)) {
                    return new InstanceInfoJsonBeanSerializer((BeanSerializerBase)serializer, false);
                }
                return serializer;
            }
        };
    }

    private void setCodecs(WebClient.Builder builder) {
        ObjectMapper objectMapper = this.objectMapper();
        builder.codecs(configurer -> {
            ClientCodecConfigurer.ClientDefaultCodecs defaults = configurer.defaultCodecs();
            defaults.jackson2JsonEncoder(new Jackson2JsonEncoder(objectMapper, MediaType.APPLICATION_JSON));
            defaults.jackson2JsonDecoder(new Jackson2JsonDecoder(objectMapper, MediaType.APPLICATION_JSON));
        });
    }

    private ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        SimpleModule jsonModule = new SimpleModule();
        jsonModule.setSerializerModifier(WebClientTransportClientFactory.createJsonSerializerModifier());
        objectMapper.registerModule(jsonModule);
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        objectMapper.addMixIn(Applications.class, ApplicationsJsonMixIn.class);
        objectMapper.addMixIn(InstanceInfo.class, InstanceInfoJsonMixIn.class);
        return objectMapper;
    }

    private ExchangeFilterFunction http4XxErrorExchangeFilterFunction() {
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            if (clientResponse.statusCode().value() == 400) {
                ClientResponse newResponse = clientResponse.mutate().statusCode(HttpStatus.OK).build();
                newResponse.body((clientHttpResponse, context) -> clientHttpResponse.getBody());
                return Mono.just(newResponse);
            }
            if (clientResponse.statusCode().equals(HttpStatus.NOT_FOUND)) {
                ClientResponse newResponse = clientResponse.mutate().statusCode(clientResponse.statusCode()).body(Flux.empty()).build();
                return Mono.just(newResponse);
            }
            return Mono.just(clientResponse);
        });
    }

    @Override
    public void shutdown() {
    }
}

