/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.appinfo.MyDataCenterInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.converters.jackson.DataCenterTypeInfoResolver;
import com.netflix.discovery.converters.jackson.builder.ApplicationsJacksonBuilder;
import com.netflix.discovery.converters.jackson.mixin.InstanceInfoJsonMixIn;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.AsyncResolver;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.discovery.shared.transport.decorator.RetryableEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.SessionedEurekaHttpClient;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.util.ClassUtils;

class EurekaClientHints
implements RuntimeHintsRegistrar {
    EurekaClientHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (!ClassUtils.isPresent("com.netflix.discovery.DiscoveryClient", classLoader)) {
            return;
        }
        hints.reflection().registerType(TypeReference.of(DiscoveryClient.class), hint -> hint.withMembers(MemberCategory.DECLARED_FIELDS, MemberCategory.INTROSPECT_DECLARED_METHODS)).registerType(TypeReference.of(EurekaEndpoint.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS)).registerType(TypeReference.of(DefaultEndpoint.class), hint -> hint.withMembers(MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS)).registerType(TypeReference.of(EurekaHttpClientDecorator.class), hint -> hint.withMembers(MemberCategory.DECLARED_FIELDS, MemberCategory.INTROSPECT_DECLARED_METHODS)).registerType(TypeReference.of(EurekaHttpResponse.class), hint -> hint.withMembers(MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS)).registerType(TypeReference.of(EurekaHttpClientDecorator.RequestExecutor.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS)).registerType(TypeReference.of(ApplicationInfoManager.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS)).registerType(TypeReference.of(InstanceInfo.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS)).registerType(TypeReference.of(InstanceInfo.ActionType.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(InstanceInfo.PortWrapper.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(LeaseInfo.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(MyDataCenterInfo.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(DataCenterInfo.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(DataCenterInfo.Name.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(EurekaClient.class), hint -> hint.withMembers(MemberCategory.INVOKE_PUBLIC_METHODS)).registerType(TypeReference.of(TimedSupervisorTask.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(DataCenterTypeInfoResolver.class), hint -> hint.withMembers(MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS)).registerType(TypeReference.of(ApplicationsJacksonBuilder.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(InstanceInfoJsonMixIn.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(Application.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(Applications.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(AsyncResolver.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(RetryableEurekaHttpClient.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(SessionedEurekaHttpClient.class), hint -> hint.withMembers(MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS)).registerType(TypeReference.of(EurekaServiceInstance.class), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.DECLARED_FIELDS));
    }
}

