/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.ClientRequest;

public class XForwardedHeadersTransformer
implements LoadBalancerClientRequestTransformer {
    private final ReactiveLoadBalancer.Factory<ServiceInstance> clientFactory;

    public XForwardedHeadersTransformer(ReactiveLoadBalancer.Factory<ServiceInstance> clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public ClientRequest transformRequest(ClientRequest request, ServiceInstance instance) {
        if (instance == null) {
            return request;
        }
        LoadBalancerProperties.XForwarded xForwarded = this.clientFactory.getProperties(instance.getServiceId()).getXForwarded();
        if (xForwarded.isEnabled()) {
            HttpHeaders headers = request.headers();
            String xForwardedHost = request.url().getHost();
            String xForwardedProto = request.url().getScheme();
            headers.add("X-Forwarded-Host", xForwardedHost);
            headers.add("X-Forwarded-Proto", xForwardedProto);
        }
        return request;
    }
}

