/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.StringUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.retry.Repeat;

public class HealthCheckServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier
implements InitializingBean,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(HealthCheckServiceInstanceListSupplier.class);
    private final LoadBalancerProperties.HealthCheck healthCheck;
    private final String defaultHealthCheckPath;
    private final Flux<List<ServiceInstance>> aliveInstancesReplay;
    private Disposable healthCheckDisposable;
    private final BiFunction<ServiceInstance, String, Mono<Boolean>> aliveFunction;

    public HealthCheckServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory, BiFunction<ServiceInstance, String, Mono<Boolean>> aliveFunction) {
        super(delegate);
        this.healthCheck = loadBalancerClientFactory.getProperties(this.getServiceId()).getHealthCheck();
        this.defaultHealthCheckPath = this.healthCheck.getPath().getOrDefault("default", "/actuator/health");
        this.aliveFunction = aliveFunction;
        Repeat aliveInstancesReplayRepeat = Repeat.onlyIf(repeatContext -> this.healthCheck.getRefetchInstances()).fixedBackoff(this.healthCheck.getRefetchInstancesInterval());
        Flux aliveInstancesFlux = Flux.defer(delegate).repeatWhen(aliveInstancesReplayRepeat).switchMap(serviceInstances -> this.healthCheckFlux((List<ServiceInstance>)serviceInstances).map(alive -> List.copyOf(alive)));
        this.aliveInstancesReplay = aliveInstancesFlux.delaySubscription(this.healthCheck.getInitialDelay()).replay(1).refCount(1);
    }

    @Override
    public void afterPropertiesSet() {
        Disposable healthCheckDisposable = this.healthCheckDisposable;
        if (healthCheckDisposable != null) {
            healthCheckDisposable.dispose();
        }
        this.healthCheckDisposable = this.aliveInstancesReplay.subscribe();
    }

    protected Flux<List<ServiceInstance>> healthCheckFlux(List<ServiceInstance> instances) {
        Repeat healthCheckFluxRepeat = Repeat.onlyIf(repeatContext -> this.healthCheck.getRepeatHealthCheck()).fixedBackoff(this.healthCheck.getInterval());
        return Flux.defer(() -> {
            ArrayList checks = new ArrayList(instances.size());
            for (ServiceInstance instance : instances) {
                Mono alive2 = this.isAlive(instance).onErrorResume(error -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Exception occurred during health check of the instance for service %s: %s", instance.getServiceId(), instance.getUri()), (Throwable)error);
                    }
                    return Mono.empty();
                }).timeout(this.healthCheck.getInterval(), Mono.defer(() -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("The instance for service %s: %s did not respond for %s during health check", instance.getServiceId(), instance.getUri(), this.healthCheck.getInterval()));
                    }
                    return Mono.empty();
                })).handle((isHealthy, sink) -> {
                    if (isHealthy.booleanValue()) {
                        sink.next(instance);
                    }
                });
                checks.add(alive2);
            }
            ArrayList result = new ArrayList();
            if (this.healthCheck.isUpdateResultsList()) {
                return Flux.merge(checks).map(alive -> {
                    result.add(alive);
                    return result;
                }).defaultIfEmpty(result);
            }
            return Flux.merge(checks).collectList();
        }).repeatWhen(healthCheckFluxRepeat);
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return this.aliveInstancesReplay;
    }

    protected Mono<Boolean> isAlive(ServiceInstance serviceInstance) {
        boolean containsService = this.healthCheck.getPath().containsKey(serviceInstance.getServiceId());
        String healthCheckPropertyValue = this.healthCheck.getPath().get(serviceInstance.getServiceId());
        if (containsService && !StringUtils.hasText(healthCheckPropertyValue)) {
            return Mono.just(true);
        }
        String healthCheckPath = healthCheckPropertyValue != null ? healthCheckPropertyValue : this.defaultHealthCheckPath;
        return this.aliveFunction.apply(this.updatedServiceInstance(serviceInstance), healthCheckPath);
    }

    @Override
    public void destroy() {
        Disposable healthCheckDisposable = this.healthCheckDisposable;
        if (healthCheckDisposable != null) {
            healthCheckDisposable.dispose();
        }
    }

    private ServiceInstance updatedServiceInstance(ServiceInstance serviceInstance) {
        Integer healthCheckPort = this.healthCheck.getPort();
        if (serviceInstance instanceof DefaultServiceInstance && healthCheckPort != null) {
            return new DefaultServiceInstance(serviceInstance.getInstanceId(), serviceInstance.getServiceId(), serviceInstance.getHost(), healthCheckPort, serviceInstance.isSecure(), serviceInstance.getMetadata());
        }
        return serviceInstance;
    }
}

