/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.tagsprovider;

import io.micrometer.core.instrument.Tags;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

public class GatewayHttpTagsProvider
implements GatewayTagsProvider {
    @Override
    public Tags apply(ServerWebExchange exchange2) {
        String outcome = "CUSTOM";
        String status = "CUSTOM";
        String httpStatusCodeStr = "NA";
        String httpMethod = exchange2.getRequest().getMethod().name();
        if (exchange2.getResponse() instanceof AbstractServerHttpResponse) {
            Integer statusInt = ((AbstractServerHttpResponse)exchange2.getResponse()).getRawStatusCode();
            if (statusInt != null) {
                httpStatusCodeStr = status = String.valueOf(statusInt);
                HttpStatus resolved = HttpStatus.resolve(statusInt);
                if (resolved != null) {
                    outcome = resolved.series().name();
                    status = resolved.name();
                }
            }
        } else {
            HttpStatusCode statusCode = exchange2.getResponse().getStatusCode();
            if (statusCode != null) {
                httpStatusCodeStr = String.valueOf(statusCode.value());
                if (statusCode instanceof HttpStatus) {
                    HttpStatus httpStatus = (HttpStatus)statusCode;
                    outcome = httpStatus.series().name();
                    status = httpStatus.name();
                }
            }
        }
        return Tags.of("outcome", outcome, "status", status, "httpStatusCode", httpStatusCodeStr, "httpMethod", httpMethod);
    }
}

