/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.net.URI;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;

public class DelegatingServiceInstance
implements ServiceInstance {
    final ServiceInstance delegate;
    private String overrideScheme;

    public DelegatingServiceInstance(ServiceInstance delegate, String overrideScheme) {
        this.delegate = delegate;
        this.overrideScheme = overrideScheme;
    }

    @Override
    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    @Override
    public String getHost() {
        return this.delegate.getHost();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public boolean isSecure() {
        if ("https".equals(this.overrideScheme) || "wss".equals(this.overrideScheme)) {
            return true;
        }
        return this.delegate.isSecure();
    }

    @Override
    public URI getUri() {
        return this.delegate.getUri();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public String getScheme() {
        String scheme = this.delegate.getScheme();
        if (scheme != null) {
            return scheme;
        }
        return this.overrideScheme;
    }
}

