/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

public interface HttpHeadersFilter {
    public static HttpHeaders filterRequest(List<HttpHeadersFilter> filters, ServerWebExchange exchange2) {
        HttpHeaders headers = exchange2.getRequest().getHeaders();
        return HttpHeadersFilter.filter(filters, headers, exchange2, Type.REQUEST);
    }

    public static HttpHeaders filter(List<HttpHeadersFilter> filters, HttpHeaders input, ServerWebExchange exchange2, Type type) {
        if (filters != null) {
            HttpHeaders filtered = input;
            for (int i2 = 0; i2 < filters.size(); ++i2) {
                HttpHeadersFilter filter2 = filters.get(i2);
                if (!filter2.supports(type)) continue;
                filtered = filter2.filter(filtered, exchange2);
            }
            return filtered;
        }
        return input;
    }

    public HttpHeaders filter(HttpHeaders var1, ServerWebExchange var2);

    default public boolean supports(Type type) {
        return type.equals((Object)Type.REQUEST);
    }

    public static enum Type {
        REQUEST,
        RESPONSE;

    }
}

