/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.filter.factory.rewrite.MessageBodyDecoder;
import org.springframework.cloud.gateway.filter.factory.rewrite.MessageBodyEncoder;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ModifyResponseBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private final Map<String, MessageBodyDecoder> messageBodyDecoders;
    private final Map<String, MessageBodyEncoder> messageBodyEncoders;
    private final List<HttpMessageReader<?>> messageReaders;

    public ModifyResponseBodyGatewayFilterFactory(List<HttpMessageReader<?>> messageReaders, Set<MessageBodyDecoder> messageBodyDecoders, Set<MessageBodyEncoder> messageBodyEncoders) {
        super(Config.class);
        this.messageReaders = messageReaders;
        this.messageBodyDecoders = messageBodyDecoders.stream().collect(Collectors.toMap(MessageBodyDecoder::encodingType, Function.identity()));
        this.messageBodyEncoders = messageBodyEncoders.stream().collect(Collectors.toMap(MessageBodyEncoder::encodingType, Function.identity()));
    }

    @Override
    public GatewayFilter apply(Config config) {
        ModifyResponseGatewayFilter gatewayFilter = new ModifyResponseGatewayFilter(config);
        gatewayFilter.setFactory(this);
        return gatewayFilter;
    }

    public static class Config {
        private Class inClass;
        private Class outClass;
        private Map<String, Object> inHints;
        private Map<String, Object> outHints;
        private String newContentType;
        private RewriteFunction rewriteFunction;

        public Class getInClass() {
            return this.inClass;
        }

        public Config setInClass(Class inClass) {
            this.inClass = inClass;
            return this;
        }

        public Class getOutClass() {
            return this.outClass;
        }

        public Config setOutClass(Class outClass) {
            this.outClass = outClass;
            return this;
        }

        public Map<String, Object> getInHints() {
            return this.inHints;
        }

        public Config setInHints(Map<String, Object> inHints) {
            this.inHints = inHints;
            return this;
        }

        public Map<String, Object> getOutHints() {
            return this.outHints;
        }

        public Config setOutHints(Map<String, Object> outHints) {
            this.outHints = outHints;
            return this;
        }

        public String getNewContentType() {
            return this.newContentType;
        }

        public Config setNewContentType(String newContentType) {
            this.newContentType = newContentType;
            return this;
        }

        public RewriteFunction getRewriteFunction() {
            return this.rewriteFunction;
        }

        public Config setRewriteFunction(RewriteFunction rewriteFunction) {
            this.rewriteFunction = rewriteFunction;
            return this;
        }

        public <T, R> Config setRewriteFunction(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
            this.setInClass(inClass);
            this.setOutClass(outClass);
            this.setRewriteFunction(rewriteFunction);
            return this;
        }
    }

    public class ModifyResponseGatewayFilter
    implements GatewayFilter,
    Ordered {
        private final Config config;
        private GatewayFilterFactory<Config> gatewayFilterFactory;

        public ModifyResponseGatewayFilter(Config config) {
            this.config = config;
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
            return chain.filter(exchange2.mutate().response(new ModifiedServerHttpResponse(exchange2, this.config)).build());
        }

        @Override
        public int getOrder() {
            return -2;
        }

        public String toString() {
            ShortcutConfigurable obj = this.gatewayFilterFactory != null ? this.gatewayFilterFactory : this;
            return GatewayToStringStyler.filterToStringCreator(obj).append("New content type", this.config.getNewContentType()).append("In class", this.config.getInClass()).append("Out class", this.config.getOutClass()).toString();
        }

        public void setFactory(GatewayFilterFactory<Config> gatewayFilterFactory) {
            this.gatewayFilterFactory = gatewayFilterFactory;
        }
    }

    protected class ModifiedServerHttpResponse
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final Config config;

        public ModifiedServerHttpResponse(ServerWebExchange exchange2, Config config) {
            super(exchange2.getResponse());
            this.exchange = exchange2;
            this.config = config;
        }

        @Override
        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
            Class inClass = this.config.getInClass();
            Class outClass = this.config.getOutClass();
            String originalResponseContentType = (String)this.exchange.getAttribute("original_response_content_type");
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Content-Type", originalResponseContentType);
            ClientResponse clientResponse = this.prepareClientResponse(body2, httpHeaders);
            Mono modifiedBody = this.extractBody(this.exchange, clientResponse, inClass).flatMap(originalBody -> this.config.getRewriteFunction().apply(this.exchange, originalBody)).switchIfEmpty(Mono.defer(() -> (Mono)this.config.getRewriteFunction().apply(this.exchange, null)));
            BodyInserter bodyInserter = BodyInserters.fromPublisher(modifiedBody, outClass);
            CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(this.exchange, this.exchange.getResponse().getHeaders());
            return bodyInserter.insert(outputMessage, new BodyInserterContext()).then(Mono.defer(() -> {
                Mono<DataBuffer> messageBody = this.writeBody(this.getDelegate(), outputMessage, outClass);
                HttpHeaders headers = this.getDelegate().getHeaders();
                if (!headers.containsKey("Transfer-Encoding") || headers.containsKey("Content-Length")) {
                    messageBody = messageBody.doOnNext(data -> headers.setContentLength(data.readableByteCount()));
                }
                if (StringUtils.hasText(this.config.newContentType)) {
                    headers.set("Content-Type", this.config.newContentType);
                }
                return this.getDelegate().writeWith(messageBody);
            }));
        }

        @Override
        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
            return this.writeWith(Flux.from(body2).flatMapSequential(p -> p));
        }

        private ClientResponse prepareClientResponse(Publisher<? extends DataBuffer> body2, HttpHeaders httpHeaders) {
            ClientResponse.Builder builder = ClientResponse.create(this.exchange.getResponse().getStatusCode(), ModifyResponseBodyGatewayFilterFactory.this.messageReaders);
            return builder.headers(headers -> headers.putAll(httpHeaders)).body(Flux.from(body2)).build();
        }

        private <T> Mono<T> extractBody(ServerWebExchange exchange2, ClientResponse clientResponse, Class<T> inClass) {
            if (byte[].class.isAssignableFrom(inClass)) {
                return clientResponse.bodyToMono(inClass);
            }
            List<String> encodingHeaders = exchange2.getResponse().getHeaders().getOrEmpty("Content-Encoding");
            for (String encoding : encodingHeaders) {
                MessageBodyDecoder decoder = ModifyResponseBodyGatewayFilterFactory.this.messageBodyDecoders.get(encoding);
                if (decoder == null) continue;
                return clientResponse.bodyToMono(byte[].class).publishOn(Schedulers.parallel()).map(decoder::decode).map(bytes -> exchange2.getResponse().bufferFactory().wrap((byte[])bytes)).map(buffer -> this.prepareClientResponse(Mono.just(buffer), exchange2.getResponse().getHeaders())).flatMap(response -> response.bodyToMono(inClass));
            }
            return clientResponse.bodyToMono(inClass);
        }

        private Mono<DataBuffer> writeBody(ServerHttpResponse httpResponse, CachedBodyOutputMessage message, Class<?> outClass) {
            Mono<DataBuffer> response = DataBufferUtils.join(message.getBody());
            if (byte[].class.isAssignableFrom(outClass)) {
                return response;
            }
            List<String> encodingHeaders = httpResponse.getHeaders().getOrEmpty("Content-Encoding");
            for (String encoding : encodingHeaders) {
                MessageBodyEncoder encoder = ModifyResponseBodyGatewayFilterFactory.this.messageBodyEncoders.get(encoding);
                if (encoder == null) continue;
                DataBufferFactory dataBufferFactory = httpResponse.bufferFactory();
                response = response.publishOn(Schedulers.parallel()).map(buffer -> {
                    byte[] encodedResponse = encoder.encode((DataBuffer)buffer);
                    DataBufferUtils.release(buffer);
                    return encodedResponse;
                }).map(dataBufferFactory::wrap);
                break;
            }
            return response;
        }
    }
}

