/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TokenRelayGatewayFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    private final ObjectProvider<ReactiveOAuth2AuthorizedClientManager> clientManagerProvider;

    public TokenRelayGatewayFilterFactory(ObjectProvider<ReactiveOAuth2AuthorizedClientManager> clientManagerProvider) {
        super(AbstractGatewayFilterFactory.NameConfig.class);
        this.clientManagerProvider = clientManagerProvider;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("name");
    }

    public GatewayFilter apply() {
        return this.apply((AbstractGatewayFilterFactory.NameConfig)null);
    }

    @Override
    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        String defaultClientRegistrationId = config == null ? null : config.getName();
        return (exchange2, chain) -> exchange2.getPrincipal().filter(principal2 -> principal2 instanceof Authentication).cast(Authentication.class).flatMap(principal2 -> this.authorizationRequest(defaultClientRegistrationId, (Authentication)principal2)).flatMap(this::authorizedClient).map(OAuth2AuthorizedClient::getAccessToken).map(token -> this.withBearerAuth(exchange2, (OAuth2AccessToken)token)).defaultIfEmpty(exchange2).flatMap(chain::filter);
    }

    private Mono<OAuth2AuthorizeRequest> authorizationRequest(String defaultClientRegistrationId, Authentication principal2) {
        String clientRegistrationId = defaultClientRegistrationId;
        if (clientRegistrationId == null && principal2 instanceof OAuth2AuthenticationToken) {
            clientRegistrationId = ((OAuth2AuthenticationToken)principal2).getAuthorizedClientRegistrationId();
        }
        return Mono.justOrEmpty(clientRegistrationId).map(OAuth2AuthorizeRequest::withClientRegistrationId).map(builder -> builder.principal(principal2).build());
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(OAuth2AuthorizeRequest request) {
        ReactiveOAuth2AuthorizedClientManager clientManager = this.clientManagerProvider.getIfAvailable();
        if (clientManager == null) {
            return Mono.error(new IllegalStateException("No ReactiveOAuth2AuthorizedClientManager bean was found. Did you include the org.springframework.boot:spring-boot-starter-oauth2-client dependency?"));
        }
        return clientManager.authorize(request);
    }

    private ServerWebExchange withBearerAuth(ServerWebExchange exchange2, OAuth2AccessToken accessToken) {
        return exchange2.mutate().request(r -> r.headers(headers -> headers.setBearerAuth(accessToken.getTokenValue()))).build();
    }
}

