/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RewritePathGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String REGEXP_KEY = "regexp";
    public static final String REPLACEMENT_KEY = "replacement";

    public RewritePathGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(REGEXP_KEY, REPLACEMENT_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        final String replacement = config.replacement.replace("$\\", "$");
        final Pattern pattern = Pattern.compile(config.regexp);
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                ServerHttpRequest req = exchange2.getRequest();
                ServerWebExchangeUtils.addOriginalRequestUrl(exchange2, req.getURI());
                String path = req.getURI().getRawPath();
                String newPath = pattern.matcher(path).replaceAll(replacement);
                ServerHttpRequest request = req.mutate().path(newPath).build();
                exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, request.getURI());
                return chain.filter(exchange2.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RewritePathGatewayFilterFactory.this).append(config.getRegexp(), replacement).toString();
            }
        };
    }

    public static class Config {
        private String regexp;
        private String replacement;

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            Assert.hasText(regexp, "regexp must have a value");
            this.regexp = regexp;
            return this;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public Config setReplacement(String replacement) {
            Assert.notNull((Object)replacement, "replacement must not be null");
            this.replacement = replacement;
            return this;
        }
    }
}

