/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.event.EnableBodyCachingEvent;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.CorePublisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.retry.Backoff;
import reactor.retry.Repeat;
import reactor.retry.RepeatContext;
import reactor.retry.RetryContext;
import reactor.util.retry.Retry;

public class RetryGatewayFilterFactory
extends AbstractGatewayFilterFactory<RetryConfig> {
    public static final String RETRY_ITERATION_KEY = "retry_iteration";
    private static final Log log = LogFactory.getLog(RetryGatewayFilterFactory.class);

    public RetryGatewayFilterFactory() {
        super(RetryConfig.class);
    }

    private static <T> List<T> toList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("retries", "statuses", "methods", "backoff.firstBackoff", "backoff.maxBackoff", "backoff.factor", "backoff.basedOnPreviousValue");
    }

    @Override
    public GatewayFilter apply(final RetryConfig retryConfig) {
        retryConfig.validate();
        Repeat<ServerWebExchange> statusCodeRepeat = null;
        if (!retryConfig.getStatuses().isEmpty() || !retryConfig.getSeries().isEmpty()) {
            Predicate<RepeatContext> repeatPredicate = context -> {
                ServerWebExchange exchange2 = (ServerWebExchange)context.applicationContext();
                if (this.exceedsMaxIterations(exchange2, retryConfig)) {
                    return false;
                }
                HttpStatusCode statusCode = exchange2.getResponse().getStatusCode();
                boolean retryableStatusCode = retryConfig.getStatuses().contains(statusCode);
                if (!retryableStatusCode && statusCode != null) {
                    retryableStatusCode = false;
                    for (int i2 = 0; i2 < retryConfig.getSeries().size(); ++i2) {
                        HttpStatus httpStatus;
                        if (!(statusCode instanceof HttpStatus) || !(httpStatus = (HttpStatus)statusCode).series().equals((Object)retryConfig.getSeries().get(i2))) continue;
                        retryableStatusCode = true;
                        break;
                    }
                }
                boolean finalRetryableStatusCode = retryableStatusCode;
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = () -> finalRetryableStatusCode;
                supplierArray[1] = () -> statusCode;
                supplierArray[2] = retryConfig::getStatuses;
                supplierArray[3] = retryConfig::getSeries;
                this.trace("retryableStatusCode: %b, statusCode %s, configured statuses %s, configured series %s", supplierArray);
                HttpMethod httpMethod = exchange2.getRequest().getMethod();
                boolean retryableMethod = retryConfig.getMethods().contains(httpMethod);
                Supplier[] supplierArray2 = new Supplier[3];
                supplierArray2[0] = () -> retryableMethod;
                supplierArray2[1] = () -> httpMethod;
                supplierArray2[2] = retryConfig::getMethods;
                this.trace("retryableMethod: %b, httpMethod %s, configured methods %s", supplierArray2);
                return retryableMethod && finalRetryableStatusCode;
            };
            statusCodeRepeat = Repeat.onlyIf(repeatPredicate).doOnRepeat(context -> this.reset((ServerWebExchange)context.applicationContext()));
            BackoffConfig backoff = retryConfig.getBackoff();
            if (backoff != null) {
                statusCodeRepeat = statusCodeRepeat.backoff(this.getBackoff(backoff));
            }
        }
        reactor.retry.Retry exceptionRetry = null;
        if (!retryConfig.getExceptions().isEmpty()) {
            Predicate<RetryContext> retryContextPredicate = context -> {
                ServerWebExchange exchange2 = (ServerWebExchange)context.applicationContext();
                if (this.exceedsMaxIterations(exchange2, retryConfig)) {
                    return false;
                }
                Throwable exception = context.exception();
                for (Class<? extends Throwable> retryableClass : retryConfig.getExceptions()) {
                    if (!retryableClass.isInstance(exception) && (exception == null || !retryableClass.isInstance(exception.getCause()))) continue;
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> this.getExceptionNameWithCause(exception);
                    supplierArray[1] = retryConfig::getExceptions;
                    this.trace("exception or its cause is retryable %s, configured exceptions %s", supplierArray);
                    HttpMethod httpMethod = exchange2.getRequest().getMethod();
                    boolean retryableMethod = retryConfig.getMethods().contains(httpMethod);
                    Supplier[] supplierArray2 = new Supplier[3];
                    supplierArray2[0] = () -> retryableMethod;
                    supplierArray2[1] = () -> httpMethod;
                    supplierArray2[2] = retryConfig::getMethods;
                    this.trace("retryableMethod: %b, httpMethod %s, configured methods %s", supplierArray2);
                    return retryableMethod;
                }
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> this.getExceptionNameWithCause(exception);
                supplierArray[1] = retryConfig::getExceptions;
                this.trace("exception or its cause is not retryable %s, configured exceptions %s", supplierArray);
                return false;
            };
            exceptionRetry = reactor.retry.Retry.onlyIf(retryContextPredicate).doOnRetry(context -> this.reset((ServerWebExchange)context.applicationContext())).retryMax(retryConfig.getRetries());
            BackoffConfig backoff = retryConfig.getBackoff();
            if (backoff != null) {
                exceptionRetry = exceptionRetry.backoff(this.getBackoff(backoff));
            }
        }
        final GatewayFilter gatewayFilter = this.apply(retryConfig.getRouteId(), statusCodeRepeat, exceptionRetry);
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                return gatewayFilter.filter(exchange2, chain);
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RetryGatewayFilterFactory.this).append("routeId", retryConfig.getRouteId()).append("retries", retryConfig.getRetries()).append("series", retryConfig.getSeries()).append("statuses", retryConfig.getStatuses()).append("methods", retryConfig.getMethods()).append("exceptions", retryConfig.getExceptions()).toString();
            }
        };
    }

    private String getExceptionNameWithCause(Throwable exception) {
        if (exception != null) {
            StringBuilder builder = new StringBuilder(exception.getClass().getName());
            Throwable cause = exception.getCause();
            if (cause != null) {
                builder.append("{cause=").append(cause.getClass().getName()).append("}");
            }
            return builder.toString();
        }
        return "null";
    }

    private Backoff getBackoff(BackoffConfig backoff) {
        return Backoff.exponential(backoff.firstBackoff, backoff.maxBackoff, backoff.factor, backoff.basedOnPreviousValue);
    }

    public boolean exceedsMaxIterations(ServerWebExchange exchange2, RetryConfig retryConfig) {
        Integer iteration = (Integer)exchange2.getAttribute(RETRY_ITERATION_KEY);
        boolean exceeds = iteration != null && iteration >= retryConfig.getRetries();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> exceeds;
        supplierArray[1] = () -> iteration;
        supplierArray[2] = retryConfig::getRetries;
        this.trace("exceedsMaxIterations %b, iteration %d, configured retries %d", supplierArray);
        return exceeds;
    }

    @Deprecated
    public void reset(ServerWebExchange exchange2) {
        Connection conn = (Connection)exchange2.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        if (conn != null) {
            this.trace("disposing response connection before next iteration", new Supplier[0]);
            conn.dispose();
            exchange2.getAttributes().remove(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        }
        ServerWebExchangeUtils.reset(exchange2);
    }

    public GatewayFilter apply(String routeId, Repeat<ServerWebExchange> repeat, reactor.retry.Retry<ServerWebExchange> retry) {
        if (routeId != null && this.getPublisher() != null) {
            this.getPublisher().publishEvent(new EnableBodyCachingEvent((Object)this, routeId));
        }
        return (exchange2, chain) -> {
            this.trace("Entering retry-filter", new Supplier[0]);
            CorePublisher<Void> publisher = chain.filter(exchange2).doOnSuccess(aVoid -> this.updateIteration(exchange2)).doOnError(throwable -> this.updateIteration(exchange2));
            if (retry != null) {
                publisher = publisher.retryWhen(Retry.withThrowable(retry.withApplicationContext(exchange2)));
            }
            if (repeat != null) {
                publisher = publisher.repeatWhen(repeat.withApplicationContext(exchange2));
            }
            return Mono.fromDirect(publisher);
        };
    }

    private void updateIteration(ServerWebExchange exchange2) {
        int iteration = exchange2.getAttributeOrDefault(RETRY_ITERATION_KEY, -1);
        int newIteration = iteration + 1;
        this.trace("setting new iteration in attr %d", () -> newIteration);
        exchange2.getAttributes().put(RETRY_ITERATION_KEY, newIteration);
    }

    @SafeVarargs
    private final void trace(String message, Supplier<Object> ... argSuppliers) {
        if (log.isTraceEnabled()) {
            Object[] args = new Object[argSuppliers.length];
            int i2 = 0;
            for (Supplier<Object> a : argSuppliers) {
                args[i2] = a.get();
                ++i2;
            }
            log.trace(String.format(message, args));
        }
    }

    public static class RetryConfig
    implements HasRouteId {
        private String routeId;
        private int retries = 3;
        private List<HttpStatus.Series> series = RetryGatewayFilterFactory.toList(HttpStatus.Series.SERVER_ERROR);
        private List<HttpStatus> statuses = new ArrayList<HttpStatus>();
        private List<HttpMethod> methods = RetryGatewayFilterFactory.toList(HttpMethod.GET);
        private List<Class<? extends Throwable>> exceptions = RetryGatewayFilterFactory.toList(IOException.class, TimeoutException.class);
        private BackoffConfig backoff;

        public RetryConfig allMethods() {
            return this.setMethods(HttpMethod.values());
        }

        public void validate() {
            Assert.isTrue(this.retries > 0, "retries must be greater than 0");
            Assert.isTrue(!this.series.isEmpty() || !this.statuses.isEmpty() || !this.exceptions.isEmpty(), "series, status and exceptions may not all be empty");
            Assert.notEmpty(this.methods, "methods may not be empty");
            if (this.backoff != null) {
                this.backoff.validate();
            }
        }

        public BackoffConfig getBackoff() {
            return this.backoff;
        }

        public RetryConfig setBackoff(BackoffConfig backoff) {
            this.backoff = backoff;
            return this;
        }

        public RetryConfig setBackoff(Duration firstBackoff, Duration maxBackoff, int factor, boolean basedOnPreviousValue) {
            this.backoff = new BackoffConfig(firstBackoff, maxBackoff, factor, basedOnPreviousValue);
            return this;
        }

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }

        public int getRetries() {
            return this.retries;
        }

        public RetryConfig setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public List<HttpStatus.Series> getSeries() {
            return this.series;
        }

        public RetryConfig setSeries(HttpStatus.Series ... series) {
            this.series = Arrays.asList(series);
            return this;
        }

        public List<HttpStatus> getStatuses() {
            return this.statuses;
        }

        public RetryConfig setStatuses(HttpStatus ... statuses) {
            this.statuses = Arrays.asList(statuses);
            return this;
        }

        public List<HttpMethod> getMethods() {
            return this.methods;
        }

        public RetryConfig setMethods(HttpMethod ... methods) {
            this.methods = Arrays.asList(methods);
            return this;
        }

        public List<Class<? extends Throwable>> getExceptions() {
            return this.exceptions;
        }

        public RetryConfig setExceptions(Class<? extends Throwable> ... exceptions) {
            this.exceptions = Arrays.asList(exceptions);
            return this;
        }
    }

    public static class BackoffConfig {
        private Duration firstBackoff = Duration.ofMillis(5L);
        private Duration maxBackoff;
        private int factor = 2;
        private boolean basedOnPreviousValue = true;

        public BackoffConfig() {
        }

        public BackoffConfig(Duration firstBackoff, Duration maxBackoff, int factor, boolean basedOnPreviousValue) {
            this.firstBackoff = firstBackoff;
            this.maxBackoff = maxBackoff;
            this.factor = factor;
            this.basedOnPreviousValue = basedOnPreviousValue;
        }

        public void validate() {
            Assert.notNull((Object)this.firstBackoff, "firstBackoff must be present");
        }

        public Duration getFirstBackoff() {
            return this.firstBackoff;
        }

        public void setFirstBackoff(Duration firstBackoff) {
            this.firstBackoff = firstBackoff;
        }

        public Duration getMaxBackoff() {
            return this.maxBackoff;
        }

        public void setMaxBackoff(Duration maxBackoff) {
            this.maxBackoff = maxBackoff;
        }

        public int getFactor() {
            return this.factor;
        }

        public void setFactor(int factor) {
            this.factor = factor;
        }

        public boolean isBasedOnPreviousValue() {
            return this.basedOnPreviousValue;
        }

        public void setBasedOnPreviousValue(boolean basedOnPreviousValue) {
            this.basedOnPreviousValue = basedOnPreviousValue;
        }
    }
}

