/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestHeaderSizeGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private static String ERROR_PREFIX = "Request Header/s size is larger than permissible limit (%s).";
    private static String ERROR = " Request Header/s size for '%s' is %s.";

    public RequestHeaderSizeGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("maxSize");
    }

    @Override
    public GatewayFilter apply(final Config config) {
        final String errorHeaderName = config.getErrorHeaderName() != null ? config.getErrorHeaderName() : "errorMessage";
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                ServerHttpRequest request = exchange2.getRequest();
                HttpHeaders headers = request.getHeaders();
                HashMap<String, Long> longHeaders = new HashMap<String, Long>();
                for (Map.Entry<String, List<String>> headerEntry : headers.entrySet()) {
                    long headerSizeInBytes = 0L;
                    headerSizeInBytes += (long)headerEntry.getKey().getBytes().length;
                    List<String> values = headerEntry.getValue();
                    for (String value : values) {
                        headerSizeInBytes += (long)value.getBytes().length;
                    }
                    if (headerSizeInBytes <= config.getMaxSize().toBytes()) continue;
                    longHeaders.put(headerEntry.getKey(), headerSizeInBytes);
                }
                if (!longHeaders.isEmpty()) {
                    exchange2.getResponse().setStatusCode(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                    exchange2.getResponse().getHeaders().add(errorHeaderName, RequestHeaderSizeGatewayFilterFactory.getErrorMessage(longHeaders, config.getMaxSize()));
                    return exchange2.getResponse().setComplete();
                }
                return chain.filter(exchange2);
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RequestHeaderSizeGatewayFilterFactory.this).append("maxSize", config.getMaxSize()).toString();
            }
        };
    }

    private static String getErrorMessage(HashMap<String, Long> longHeaders, DataSize maxSize) {
        StringBuilder msg = new StringBuilder(String.format(ERROR_PREFIX, maxSize));
        longHeaders.forEach((header, size) -> msg.append(String.format(ERROR, header, DataSize.of(size, DataUnit.BYTES))));
        return msg.toString();
    }

    public static class Config {
        private DataSize maxSize = DataSize.ofBytes(16000L);
        private String errorHeaderName;

        public DataSize getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(DataSize maxSize) {
            this.maxSize = maxSize;
        }

        public String getErrorHeaderName() {
            return this.errorHeaderName;
        }

        public void setErrorHeaderName(String errorHeaderName) {
            this.errorHeaderName = errorHeaderName;
        }
    }
}

