/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RemoveRequestParameterGatewayFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    public RemoveRequestParameterGatewayFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name");
    }

    @Override
    public GatewayFilter apply(final AbstractGatewayFilterFactory.NameConfig config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                ServerHttpRequest request = exchange2.getRequest();
                LinkedMultiValueMap queryParams = new LinkedMultiValueMap(request.getQueryParams());
                queryParams.remove(config.getName());
                URI newUri = ((UriComponentsBuilder)UriComponentsBuilder.fromUri(request.getURI()).replaceQueryParams(CollectionUtils.unmodifiableMultiValueMap(queryParams))).build().toUri();
                ServerHttpRequest updatedRequest = exchange2.getRequest().mutate().uri(newUri).build();
                return chain.filter(exchange2.mutate().request(updatedRequest).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RemoveRequestParameterGatewayFilterFactory.this).append("name", config.getName()).toString();
            }
        };
    }
}

