/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MapRequestHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String FROM_HEADER_KEY = "fromHeader";
    public static final String TO_HEADER_KEY = "toHeader";

    public MapRequestHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(FROM_HEADER_KEY, TO_HEADER_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                if (!exchange2.getRequest().getHeaders().containsKey(config.getFromHeader())) {
                    return chain.filter(exchange2);
                }
                Object headerValues = exchange2.getRequest().getHeaders().get(config.getFromHeader());
                ServerHttpRequest request = exchange2.getRequest().mutate().headers(arg_0 -> 1.lambda$filter$0(config, (List)headerValues, arg_0)).build();
                return chain.filter(exchange2.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(MapRequestHeaderGatewayFilterFactory.this).append(MapRequestHeaderGatewayFilterFactory.FROM_HEADER_KEY, config.getFromHeader()).append(MapRequestHeaderGatewayFilterFactory.TO_HEADER_KEY, config.getToHeader()).toString();
            }

            private static /* synthetic */ void lambda$filter$0(Config config2, List headerValues, HttpHeaders i2) {
                i2.addAll(config2.getToHeader(), (List<? extends String>)headerValues);
            }
        };
    }

    public static class Config {
        private String fromHeader;
        private String toHeader;

        public String getFromHeader() {
            return this.fromHeader;
        }

        public Config setFromHeader(String fromHeader) {
            this.fromHeader = fromHeader;
            return this;
        }

        public String getToHeader() {
            return this.toHeader;
        }

        public Config setToHeader(String toHeader) {
            this.toHeader = toHeader;
            return this;
        }

        public String toString() {
            return new ToStringCreator(this).append(MapRequestHeaderGatewayFilterFactory.FROM_HEADER_KEY, this.fromHeader).append(MapRequestHeaderGatewayFilterFactory.TO_HEADER_KEY, this.toHeader).toString();
        }
    }
}

