/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ForwardPathFilter
implements GlobalFilter,
Ordered {
    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        Route route = (Route)exchange2.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        URI routeUri = route.getUri();
        String scheme = routeUri.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange2) || !"forward".equals(scheme)) {
            return chain.filter(exchange2);
        }
        exchange2 = exchange2.mutate().request(exchange2.getRequest().mutate().path(routeUri.getPath()).build()).build();
        return chain.filter(exchange2);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

