/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.netty.channel.ChannelOption;
import java.time.Duration;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.cloud.gateway.config.HttpClientCustomizer;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.config.HttpClientSslConfigurer;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpResponseDecoderSpec;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.ProxyProvider;

public class HttpClientFactory
extends AbstractFactoryBean<HttpClient> {
    protected final HttpClientProperties properties;
    protected final ServerProperties serverProperties;
    protected final HttpClientSslConfigurer sslConfigurer;
    protected final List<HttpClientCustomizer> customizers;

    public HttpClientFactory(HttpClientProperties properties, ServerProperties serverProperties, List<HttpClientCustomizer> customizers) {
        this.properties = properties;
        this.serverProperties = serverProperties;
        this.sslConfigurer = null;
        this.customizers = customizers;
    }

    public HttpClientFactory(HttpClientProperties properties, ServerProperties serverProperties, HttpClientSslConfigurer sslConfigurer, List<HttpClientCustomizer> customizers) {
        this.properties = properties;
        this.serverProperties = serverProperties;
        this.sslConfigurer = sslConfigurer;
        this.customizers = customizers;
    }

    @Override
    public Class<?> getObjectType() {
        return HttpClient.class;
    }

    @Override
    protected HttpClient createInstance() {
        ConnectionProvider connectionProvider = this.buildConnectionProvider(this.properties);
        HttpClient httpClient = HttpClient.create(connectionProvider).httpResponseDecoder(this::httpResponseDecoder);
        if (this.serverProperties.getHttp2().isEnabled()) {
            httpClient = httpClient.protocol(HttpProtocol.HTTP11, HttpProtocol.H2);
        }
        if (this.properties.getConnectTimeout() != null) {
            httpClient = (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.properties.getConnectTimeout());
        }
        httpClient = this.configureProxy(httpClient);
        httpClient = this.configureSsl(httpClient);
        if (this.properties.isWiretap()) {
            httpClient = httpClient.wiretap(true);
        }
        if (this.properties.isCompression()) {
            httpClient = httpClient.compress(true);
        }
        httpClient = this.applyCustomizers(httpClient);
        return httpClient;
    }

    protected HttpClient configureSsl(HttpClient httpClient) {
        return this.sslConfigurer.configureSsl(httpClient);
    }

    private HttpClient applyCustomizers(HttpClient httpClient) {
        if (!CollectionUtils.isEmpty(this.customizers)) {
            this.customizers.sort(AnnotationAwareOrderComparator.INSTANCE);
            for (HttpClientCustomizer customizer2 : this.customizers) {
                httpClient = customizer2.customize(httpClient);
            }
        }
        return httpClient;
    }

    protected HttpClient configureProxy(HttpClient httpClient) {
        if (StringUtils.hasText(this.properties.getProxy().getHost())) {
            HttpClientProperties.Proxy proxy = this.properties.getProxy();
            httpClient = (HttpClient)httpClient.proxy(proxySpec -> this.configureProxyProvider(proxy, (ProxyProvider.TypeSpec)proxySpec));
        }
        return httpClient;
    }

    protected ProxyProvider.Builder configureProxyProvider(HttpClientProperties.Proxy proxy, ProxyProvider.TypeSpec proxySpec) {
        ProxyProvider.Builder builder = proxySpec.type(proxy.getType()).host(proxy.getHost());
        PropertyMapper map = PropertyMapper.get();
        map.from(proxy::getPort).whenNonNull().to(builder::port);
        map.from(proxy::getUsername).whenHasText().to(builder::username);
        map.from(proxy::getPassword).whenHasText().to(password -> builder.password(s -> password));
        map.from(proxy::getNonProxyHostsPattern).whenHasText().to(builder::nonProxyHosts);
        return builder;
    }

    protected HttpResponseDecoderSpec httpResponseDecoder(HttpResponseDecoderSpec spec) {
        if (this.properties.getMaxHeaderSize() != null) {
            spec.maxHeaderSize((int)this.properties.getMaxHeaderSize().toBytes());
        }
        if (this.properties.getMaxInitialLineLength() != null) {
            spec.maxInitialLineLength((int)this.properties.getMaxInitialLineLength().toBytes());
        }
        return spec;
    }

    protected ConnectionProvider buildConnectionProvider(HttpClientProperties properties) {
        ConnectionProvider connectionProvider;
        HttpClientProperties.Pool pool = properties.getPool();
        if (pool.getType() == HttpClientProperties.Pool.PoolType.DISABLED) {
            connectionProvider = ConnectionProvider.newConnection();
        } else {
            ConnectionProvider.Builder builder = ConnectionProvider.builder(pool.getName());
            if (pool.getType() == HttpClientProperties.Pool.PoolType.FIXED) {
                ((ConnectionProvider.Builder)((ConnectionProvider.Builder)builder.maxConnections(pool.getMaxConnections())).pendingAcquireMaxCount(-1)).pendingAcquireTimeout(Duration.ofMillis(pool.getAcquireTimeout()));
            } else {
                ((ConnectionProvider.Builder)((ConnectionProvider.Builder)builder.maxConnections(Integer.MAX_VALUE)).pendingAcquireTimeout(Duration.ofMillis(0L))).pendingAcquireMaxCount(-1);
            }
            if (pool.getMaxIdleTime() != null) {
                builder.maxIdleTime(pool.getMaxIdleTime());
            }
            if (pool.getMaxLifeTime() != null) {
                builder.maxLifeTime(pool.getMaxLifeTime());
            }
            builder.evictInBackground(pool.getEvictionInterval());
            builder.metrics(pool.isMetrics());
            connectionProvider = builder.build();
        }
        return connectionProvider;
    }
}

