/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.actuate;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.cloud.gateway.actuate.GatewayControllerEndpoint;
import org.springframework.cloud.gateway.actuate.GatewayEndpointInfo;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.event.RouteDeletedEvent;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionWriter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.Ordered;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AbstractGatewayControllerEndpoint
implements ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(GatewayControllerEndpoint.class);
    protected RouteDefinitionLocator routeDefinitionLocator;
    protected List<GlobalFilter> globalFilters;
    protected List<GatewayFilterFactory> GatewayFilters;
    protected List<RoutePredicateFactory> routePredicates;
    protected RouteDefinitionWriter routeDefinitionWriter;
    protected RouteLocator routeLocator;
    protected ApplicationEventPublisher publisher;
    protected WebEndpointProperties webEndpointProperties;
    private final SimpleMetadataReaderFactory simpleMetadataReaderFactory = new SimpleMetadataReaderFactory();

    @Deprecated
    public AbstractGatewayControllerEndpoint(RouteDefinitionLocator routeDefinitionLocator, List<GlobalFilter> globalFilters, List<GatewayFilterFactory> gatewayFilters, List<RoutePredicateFactory> routePredicates, RouteDefinitionWriter routeDefinitionWriter, RouteLocator routeLocator) {
        this(routeDefinitionLocator, globalFilters, gatewayFilters, routePredicates, routeDefinitionWriter, routeLocator, new WebEndpointProperties());
    }

    public AbstractGatewayControllerEndpoint(RouteDefinitionLocator routeDefinitionLocator, List<GlobalFilter> globalFilters, List<GatewayFilterFactory> gatewayFilters, List<RoutePredicateFactory> routePredicates, RouteDefinitionWriter routeDefinitionWriter, RouteLocator routeLocator, WebEndpointProperties webEndpointProperties) {
        this.routeDefinitionLocator = routeDefinitionLocator;
        this.globalFilters = globalFilters;
        this.GatewayFilters = gatewayFilters;
        this.routePredicates = routePredicates;
        this.routeDefinitionWriter = routeDefinitionWriter;
        this.routeLocator = routeLocator;
        this.webEndpointProperties = webEndpointProperties;
    }

    @GetMapping(value={"/"})
    Mono<List<GatewayEndpointInfo>> getEndpoints() {
        List<GatewayEndpointInfo> endpoints = this.mergeEndpoints(this.getAvailableEndpointsForClass(AbstractGatewayControllerEndpoint.class.getName()), this.getAvailableEndpointsForClass(GatewayControllerEndpoint.class.getName()));
        return Flux.fromIterable(endpoints).map(p -> p).flatMap(path -> this.routeLocator.getRoutes().map(r -> this.generateHref((Route)r, (GatewayEndpointInfo)path)).distinct().collectList().flatMapMany(Flux::fromIterable)).distinct().collectList();
    }

    private List<GatewayEndpointInfo> mergeEndpoints(List<GatewayEndpointInfo> listA, List<GatewayEndpointInfo> listB) {
        HashMap mergedMap = new HashMap();
        Stream.concat(listA.stream(), listB.stream()).forEach(e -> mergedMap.computeIfAbsent(e.getHref(), k -> new ArrayList()).addAll(Arrays.asList(e.getMethods())));
        return mergedMap.entrySet().stream().map(entry -> new GatewayEndpointInfo((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    private List<GatewayEndpointInfo> getAvailableEndpointsForClass(String className) {
        try {
            MetadataReader metadataReader = this.simpleMetadataReaderFactory.getMetadataReader(className);
            Set<MethodMetadata> annotatedMethods = metadataReader.getAnnotationMetadata().getAnnotatedMethods(RequestMapping.class.getName());
            String gatewayActuatorPath = this.webEndpointProperties.getBasePath() + "/gateway";
            return annotatedMethods.stream().map(method -> new GatewayEndpointInfo(gatewayActuatorPath + ((String[])method.getAnnotationAttributes(RequestMapping.class.getName()).get("path"))[0], ((RequestMethod[])method.getAnnotationAttributes(RequestMapping.class.getName()).get("method"))[0].name())).collect(Collectors.toList());
        }
        catch (IOException exception) {
            log.warn(exception.getMessage());
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage());
        }
    }

    private GatewayEndpointInfo generateHref(Route r, GatewayEndpointInfo path) {
        return new GatewayEndpointInfo(path.getHref().replace("{id}", r.getId()), Arrays.asList(path.getMethods()));
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @PostMapping(value={"/refresh"})
    public Mono<Void> refresh(@RequestParam(value="metadata", required=false) List<String> byMetadata) {
        this.publishRefreshEvent(byMetadata);
        return Mono.empty();
    }

    private void publishRefreshEvent(List<String> byMetadata) {
        RefreshRoutesEvent event = !CollectionUtils.isEmpty(byMetadata) ? new RefreshRoutesEvent((Object)this, this.convertToMap(byMetadata)) : new RefreshRoutesEvent(this);
        this.publisher.publishEvent(event);
    }

    private Map<String, Object> convertToMap(List<String> byMetadata) {
        return byMetadata.stream().map(keyValueStr -> keyValueStr.split(":")).collect(Collectors.toMap(kv -> kv[0], kv -> ((String[])kv).length > 1 ? kv[1] : null));
    }

    @GetMapping(value={"/globalfilters"})
    public Mono<HashMap<String, Object>> globalfilters() {
        return this.getNamesToOrders(this.globalFilters);
    }

    @GetMapping(value={"/routefilters"})
    public Mono<HashMap<String, Object>> routefilers() {
        return this.getNamesToOrders(this.GatewayFilters);
    }

    @GetMapping(value={"/routepredicates"})
    public Mono<HashMap<String, Object>> routepredicates() {
        return this.getNamesToOrders(this.routePredicates);
    }

    private <T> Mono<HashMap<String, Object>> getNamesToOrders(List<T> list) {
        return Flux.fromIterable(list).reduce(new HashMap(), this::putItem);
    }

    private HashMap<String, Object> putItem(HashMap<String, Object> map, Object o) {
        Integer order = null;
        if (o instanceof Ordered) {
            order = ((Ordered)o).getOrder();
        }
        map.put(o.toString(), order);
        return map;
    }

    @PostMapping(value={"/routes/{id}"})
    public Mono<ResponseEntity<Object>> save(@PathVariable String id, @RequestBody RouteDefinition route) {
        return Mono.just(route).doOnNext(this::validateRouteDefinition).flatMap(routeDefinition -> this.routeDefinitionWriter.save(Mono.just(routeDefinition).map(r -> {
            r.setId(id);
            log.debug("Saving route: " + route);
            return r;
        })).then(Mono.defer(() -> Mono.just(ResponseEntity.created(URI.create("/routes/" + id)).build())))).switchIfEmpty(Mono.defer(() -> Mono.just(ResponseEntity.badRequest().build())));
    }

    @PostMapping(value={"/routes"})
    public Mono<ResponseEntity<Object>> save(@RequestBody List<RouteDefinition> routes) {
        routes.stream().forEach(routeDef -> {
            this.validateRouteDefinition((RouteDefinition)routeDef);
            this.validateRouteId((RouteDefinition)routeDef);
        });
        return Flux.fromIterable(routes).flatMap(routeDefinition -> this.routeDefinitionWriter.save(Mono.just(routeDefinition).map(r -> {
            log.debug("Saving route: " + routeDefinition);
            return r;
        }))).then(Mono.defer(() -> Mono.just(ResponseEntity.ok().build()))).switchIfEmpty(Mono.defer(() -> Mono.just(ResponseEntity.badRequest().build())));
    }

    private void validateRouteId(RouteDefinition routeDefinition) {
        if (routeDefinition.getId() == null) {
            this.handleError("Saving multiple routes require specifying the ID for every route");
        }
    }

    private void validateRouteDefinition(RouteDefinition routeDefinition) {
        Set<String> unavailableFilterDefinitions = routeDefinition.getFilters().stream().filter(rd -> !this.isAvailable((FilterDefinition)rd)).map(FilterDefinition::getName).collect(Collectors.toSet());
        Set<String> unavailablePredicatesDefinitions = routeDefinition.getPredicates().stream().filter(rd -> !this.isAvailable((PredicateDefinition)rd)).map(PredicateDefinition::getName).collect(Collectors.toSet());
        if (!unavailableFilterDefinitions.isEmpty()) {
            this.handleUnavailableDefinition(FilterDefinition.class.getSimpleName(), unavailableFilterDefinitions);
        } else if (!unavailablePredicatesDefinitions.isEmpty()) {
            this.handleUnavailableDefinition(PredicateDefinition.class.getSimpleName(), unavailablePredicatesDefinitions);
        }
        this.validateRouteUri(routeDefinition.getUri());
    }

    private void validateRouteUri(URI uri) {
        if (uri == null) {
            this.handleError("The URI can not be empty");
        }
        if (!StringUtils.hasText(uri.getScheme())) {
            this.handleError(String.format("The URI format [%s] is incorrect, scheme can not be empty", uri));
        }
    }

    private void handleUnavailableDefinition(String simpleName, Set<String> unavailableDefinitions) {
        String errorMessage = String.format("Invalid %s: %s", simpleName, unavailableDefinitions);
        log.warn(errorMessage);
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, errorMessage);
    }

    private void handleError(String errorMessage) {
        log.warn(errorMessage);
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, errorMessage);
    }

    private boolean isAvailable(FilterDefinition filterDefinition) {
        return this.GatewayFilters.stream().anyMatch(gatewayFilterFactory -> filterDefinition.getName().equals(gatewayFilterFactory.name()));
    }

    private boolean isAvailable(PredicateDefinition predicateDefinition) {
        return this.routePredicates.stream().anyMatch(routePredicate -> predicateDefinition.getName().equals(routePredicate.name()));
    }

    @DeleteMapping(value={"/routes/{id}"})
    public Mono<ResponseEntity<Object>> delete(@PathVariable String id) {
        return this.routeDefinitionWriter.delete(Mono.just(id)).then(Mono.defer(() -> {
            this.publisher.publishEvent(new RouteDeletedEvent((Object)this, id));
            return Mono.just(ResponseEntity.ok().build());
        })).onErrorResume(t -> t instanceof NotFoundException, t -> Mono.just(ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/routes/{id}/combinedfilters"})
    public Mono<HashMap<String, Object>> combinedfilters(@PathVariable String id) {
        return this.routeLocator.getRoutes().filter(route -> route.getId().equals(id)).reduce(new HashMap(), this::putItem);
    }
}

