/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.util.CollectionUtils;

public class DefaultsBindHandlerAdvisor
implements ConfigurationPropertiesBindHandlerAdvisor {
    private final Map<ConfigurationPropertyName, ConfigurationPropertyName> mappings = new LinkedHashMap<ConfigurationPropertyName, ConfigurationPropertyName>();

    public DefaultsBindHandlerAdvisor(Map<ConfigurationPropertyName, ConfigurationPropertyName> additionalMappings) {
        if (!CollectionUtils.isEmpty(additionalMappings)) {
            this.mappings.putAll(additionalMappings);
        }
    }

    @Override
    public BindHandler apply(final BindHandler bindHandler) {
        AbstractBindHandler handler = new AbstractBindHandler(bindHandler){

            @Override
            public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
                BindResult<T> result;
                ConfigurationPropertyName defaultName = DefaultsBindHandlerAdvisor.this.getDefaultName(name);
                if (defaultName != null && (result = context.getBinder().bind(defaultName, target)).isBound()) {
                    return target.withExistingValue(result.get());
                }
                return bindHandler.onStart(name, target, context);
            }
        };
        return handler;
    }

    private ConfigurationPropertyName getDefaultName(ConfigurationPropertyName name) {
        for (Map.Entry<ConfigurationPropertyName, ConfigurationPropertyName> mapping : this.mappings.entrySet()) {
            ConfigurationPropertyName from = mapping.getKey();
            ConfigurationPropertyName to = mapping.getValue();
            if (!from.isAncestorOf(name) || name.getNumberOfElements() <= from.getNumberOfElements()) continue;
            ConfigurationPropertyName defaultName = to;
            for (int i2 = from.getNumberOfElements() + 1; i2 < name.getNumberOfElements(); ++i2) {
                defaultName = defaultName.append(name.getElement(i2, ConfigurationPropertyName.Form.UNIFORM));
            }
            return defaultName;
        }
        return null;
    }

    public static interface MappingsProvider {
        public Map<ConfigurationPropertyName, ConfigurationPropertyName> getDefaultMappings();
    }
}

