/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.bootstrap.TextEncryptorBindHandler;
import org.springframework.cloud.bootstrap.TextEncryptorConfigBootstrapper;
import org.springframework.cloud.bootstrap.encrypt.AbstractEnvironmentDecrypt;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class TextEncryptorUtils {
    static Map<String, Object> decrypt(AbstractEnvironmentDecrypt decryptor, ConfigurableEnvironment environment2, MutablePropertySources propertySources) {
        TextEncryptor encryptor = TextEncryptorUtils.getTextEncryptor(decryptor, environment2);
        return decryptor.decrypt(encryptor, propertySources);
    }

    static TextEncryptor getTextEncryptor(AbstractEnvironmentDecrypt decryptor, ConfigurableEnvironment environment2) {
        Binder binder = Binder.get(environment2);
        KeyProperties keyProperties = binder.bind("encrypt", KeyProperties.class).orElseGet(KeyProperties::new);
        if (TextEncryptorUtils.keysConfigured(keyProperties)) {
            decryptor.setFailOnError(keyProperties.isFailOnError());
            if (ClassUtils.isPresent("org.springframework.security.rsa.crypto.RsaSecretEncryptor", null)) {
                RsaProperties rsaProperties = binder.bind("encrypt.rsa", RsaProperties.class).orElseGet(RsaProperties::new);
                return TextEncryptorUtils.createTextEncryptor(keyProperties, rsaProperties);
            }
            return new EncryptorFactory(keyProperties.getSalt()).create(keyProperties.getKey());
        }
        return new FailsafeTextEncryptor();
    }

    public static void register(BootstrapRegistry registry) {
        registry.registerIfAbsent(TextEncryptor.class, context -> {
            KeyProperties keyProperties = context.get(KeyProperties.class);
            if (TextEncryptorConfigBootstrapper.keysConfigured(keyProperties)) {
                if (TextEncryptorConfigBootstrapper.RSA_IS_PRESENT) {
                    RsaProperties rsaProperties = context.get(RsaProperties.class);
                    return TextEncryptorUtils.createTextEncryptor(keyProperties, rsaProperties);
                }
                return new EncryptorFactory(keyProperties.getSalt()).create(keyProperties.getKey());
            }
            return new FailsafeTextEncryptor();
        });
        registry.registerIfAbsent(BindHandler.class, context -> {
            TextEncryptor textEncryptor = context.get(TextEncryptor.class);
            if (textEncryptor != null) {
                KeyProperties keyProperties = context.get(KeyProperties.class);
                return new TextEncryptorBindHandler(textEncryptor, keyProperties);
            }
            return null;
        });
    }

    public static void promote(BootstrapContext bootstrapContext, ConfigurableListableBeanFactory beanFactory) {
        TextEncryptor textEncryptor = bootstrapContext.get(TextEncryptor.class);
        if (textEncryptor != null) {
            beanFactory.registerSingleton("textEncryptor", textEncryptor);
        }
    }

    public static TextEncryptor createTextEncryptor(KeyProperties keyProperties, RsaProperties rsaProperties) {
        KeyProperties.KeyStore keyStore = keyProperties.getKeyStore();
        if (keyStore.getLocation() != null) {
            if (keyStore.getLocation().exists()) {
                return new RsaSecretEncryptor(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray(), keyStore.getType()).getKeyPair(keyStore.getAlias(), keyStore.getSecret().toCharArray()), rsaProperties.getAlgorithm(), rsaProperties.getSalt(), rsaProperties.isStrong());
            }
            throw new IllegalStateException("Invalid keystore location");
        }
        return new EncryptorFactory(keyProperties.getSalt()).create(keyProperties.getKey());
    }

    public static boolean keysConfigured(KeyProperties properties) {
        if (TextEncryptorUtils.hasProperty(properties.getKeyStore().getLocation())) {
            return TextEncryptorUtils.hasProperty(properties.getKeyStore().getPassword());
        }
        return TextEncryptorUtils.hasProperty(properties.getKey());
    }

    static boolean hasProperty(Object value) {
        if (value instanceof String) {
            return StringUtils.hasText((String)value);
        }
        return value != null;
    }

    public static boolean isLegacyBootstrap(Environment environment2) {
        boolean isLegacy = PropertyUtils.useLegacyProcessing(environment2);
        boolean isBootstrapEnabled = PropertyUtils.bootstrapEnabled(environment2);
        return isLegacy || isBootstrapEnabled;
    }

    public static class FailsafeTextEncryptor
    implements TextEncryptor {
        @Override
        public String encrypt(String text) {
            throw new UnsupportedOperationException("No encryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }

        @Override
        public String decrypt(String encryptedText) {
            throw new UnsupportedOperationException("No decryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }
    }
}

