/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class TextEncryptorBindHandler
extends AbstractBindHandler {
    private static final Log logger = LogFactory.getLog(TextEncryptorBindHandler.class);
    protected static final String ENCRYPTED_PROPERTY_PREFIX = "{cipher}";
    private final TextEncryptor textEncryptor;
    private final KeyProperties keyProperties;

    public TextEncryptorBindHandler(TextEncryptor textEncryptor, KeyProperties keyProperties) {
        this.textEncryptor = textEncryptor;
        this.keyProperties = keyProperties;
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
        if (result instanceof String && ((String)result).startsWith(ENCRYPTED_PROPERTY_PREFIX)) {
            return this.decrypt(name.toString(), (String)result);
        }
        return result;
    }

    private String decrypt(String key, String original) {
        String value = original.substring(ENCRYPTED_PROPERTY_PREFIX.length());
        try {
            value = this.textEncryptor.decrypt(value);
            if (logger.isDebugEnabled()) {
                logger.debug("Decrypted: key=" + key);
            }
            return value;
        }
        catch (Exception e) {
            String message = "Cannot decrypt: key=" + key;
            if (logger.isDebugEnabled()) {
                logger.warn(message, e);
            } else {
                logger.warn(message);
            }
            if (this.keyProperties.isFailOnError()) {
                throw new IllegalStateException(message, e);
            }
            return "";
        }
    }
}

