/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class OriginTrackedResource
implements Resource,
OriginProvider {
    private final Resource resource;
    private final Origin origin;

    OriginTrackedResource(Resource resource2, Origin origin) {
        Assert.notNull((Object)resource2, "Resource must not be null");
        this.resource = resource2;
        this.origin = origin;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getResource().getInputStream();
    }

    @Override
    public boolean exists() {
        return this.getResource().exists();
    }

    @Override
    public boolean isReadable() {
        return this.getResource().isReadable();
    }

    @Override
    public boolean isOpen() {
        return this.getResource().isOpen();
    }

    @Override
    public boolean isFile() {
        return this.getResource().isFile();
    }

    @Override
    public URL getURL() throws IOException {
        return this.getResource().getURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.getResource().getURI();
    }

    @Override
    public File getFile() throws IOException {
        return this.getResource().getFile();
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        return this.getResource().readableChannel();
    }

    @Override
    public long contentLength() throws IOException {
        return this.getResource().contentLength();
    }

    @Override
    public long lastModified() throws IOException {
        return this.getResource().lastModified();
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        return this.getResource().createRelative(relativePath);
    }

    @Override
    public String getFilename() {
        return this.getResource().getFilename();
    }

    @Override
    public String getDescription() {
        return this.getResource().getDescription();
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OriginTrackedResource other = (OriginTrackedResource)obj;
        return this.resource.equals(other) && ObjectUtils.nullSafeEquals(this.origin, other.origin);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.resource.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.origin);
        return result;
    }

    public String toString() {
        return this.resource.toString();
    }

    public static OriginTrackedWritableResource of(WritableResource resource2, Origin origin) {
        return (OriginTrackedWritableResource)OriginTrackedResource.of((Resource)resource2, origin);
    }

    public static OriginTrackedResource of(Resource resource2, Origin origin) {
        if (resource2 instanceof WritableResource) {
            WritableResource writableResource = (WritableResource)resource2;
            return new OriginTrackedWritableResource(writableResource, origin);
        }
        return new OriginTrackedResource(resource2, origin);
    }

    public static class OriginTrackedWritableResource
    extends OriginTrackedResource
    implements WritableResource {
        OriginTrackedWritableResource(WritableResource resource2, Origin origin) {
            super(resource2, origin);
        }

        @Override
        public WritableResource getResource() {
            return (WritableResource)super.getResource();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.getResource().getOutputStream();
        }
    }
}

