/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import org.apache.commons.logging.Log;

public enum LogLevel {
    TRACE(Log::trace),
    DEBUG(Log::debug),
    INFO(Log::info),
    WARN(Log::warn),
    ERROR(Log::error),
    FATAL(Log::fatal),
    OFF(null);

    private final LogMethod logMethod;

    private LogLevel(LogMethod logMethod) {
        this.logMethod = logMethod;
    }

    public void log(Log logger2, Object message) {
        this.log(logger2, message, null);
    }

    public void log(Log logger2, Object message, Throwable cause) {
        if (logger2 != null && this.logMethod != null) {
            this.logMethod.log(logger2, message, cause);
        }
    }

    @FunctionalInterface
    private static interface LogMethod {
        public void log(Log var1, Object var2, Throwable var3);
    }
}

