/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.jackson.JsonMixin;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class JsonMixinModuleEntries {
    private final Map<Object, Object> entries;

    private JsonMixinModuleEntries(Builder builder) {
        this.entries = new LinkedHashMap<Object, Object>(builder.entries);
    }

    public static JsonMixinModuleEntries create(Consumer<Builder> mixins) {
        Builder builder = new Builder();
        mixins.accept(builder);
        return builder.build();
    }

    public static JsonMixinModuleEntries scan(ApplicationContext context, Collection<String> basePackages) {
        return JsonMixinModuleEntries.create(builder -> {
            if (ObjectUtils.isEmpty(basePackages)) {
                return;
            }
            JsonMixinComponentScanner scanner = new JsonMixinComponentScanner();
            scanner.setEnvironment(context.getEnvironment());
            scanner.setResourceLoader(context);
            for (String basePackage : basePackages) {
                if (!StringUtils.hasText(basePackage)) continue;
                for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
                    Class<?> mixinClass = ClassUtils.resolveClassName(candidate.getBeanClassName(), context.getClassLoader());
                    JsonMixinModuleEntries.registerMixinClass(builder, mixinClass);
                }
            }
        });
    }

    private static void registerMixinClass(Builder builder, Class<?> mixinClass) {
        MergedAnnotation<JsonMixin> annotation = MergedAnnotations.from(mixinClass, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(JsonMixin.class);
        for (Class<?> targetType : annotation.getClassArray("type")) {
            builder.and(targetType, mixinClass);
        }
    }

    public void doWithEntry(ClassLoader classLoader, BiConsumer<Class<?>, Class<?>> action) {
        this.entries.forEach((type, mixin) -> action.accept(this.resolveClassNameIfNecessary(type, classLoader), this.resolveClassNameIfNecessary(mixin, classLoader)));
    }

    private Class<?> resolveClassNameIfNecessary(Object type, ClassLoader classLoader) {
        Class<?> clazz;
        return type instanceof Class ? (clazz = (Class<?>)type) : ClassUtils.resolveClassName((String)type, classLoader);
    }

    public static class Builder {
        private final Map<Object, Object> entries = new LinkedHashMap<Object, Object>();

        Builder() {
        }

        public Builder and(String typeClassName, String mixinClassName) {
            this.entries.put(typeClassName, mixinClassName);
            return this;
        }

        public Builder and(Class<?> type, Class<?> mixinClass) {
            this.entries.put(type, mixinClass);
            return this;
        }

        JsonMixinModuleEntries build() {
            return new JsonMixinModuleEntries(this);
        }
    }

    static class JsonMixinComponentScanner
    extends ClassPathScanningCandidateComponentProvider {
        JsonMixinComponentScanner() {
            this.addIncludeFilter(new AnnotationTypeFilter(JsonMixin.class));
        }

        @Override
        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }
}

