/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataNotFoundException;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.origin.Origin;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ConfigDataResourceNotFoundException
extends ConfigDataNotFoundException {
    private final ConfigDataResource resource;
    private final ConfigDataLocation location;

    public ConfigDataResourceNotFoundException(ConfigDataResource resource2) {
        this(resource2, null);
    }

    public ConfigDataResourceNotFoundException(ConfigDataResource resource2, Throwable cause) {
        this(resource2, null, cause);
    }

    private ConfigDataResourceNotFoundException(ConfigDataResource resource2, ConfigDataLocation location, Throwable cause) {
        super(ConfigDataResourceNotFoundException.getMessage(resource2, location), cause);
        Assert.notNull((Object)resource2, "Resource must not be null");
        this.resource = resource2;
        this.location = location;
    }

    public ConfigDataResource getResource() {
        return this.resource;
    }

    public ConfigDataLocation getLocation() {
        return this.location;
    }

    @Override
    public Origin getOrigin() {
        return Origin.from(this.location);
    }

    @Override
    public String getReferenceDescription() {
        return ConfigDataResourceNotFoundException.getReferenceDescription(this.resource, this.location);
    }

    ConfigDataResourceNotFoundException withLocation(ConfigDataLocation location) {
        return new ConfigDataResourceNotFoundException(this.resource, location, this.getCause());
    }

    private static String getMessage(ConfigDataResource resource2, ConfigDataLocation location) {
        return String.format("Config data %s cannot be found", ConfigDataResourceNotFoundException.getReferenceDescription(resource2, location));
    }

    private static String getReferenceDescription(ConfigDataResource resource2, ConfigDataLocation location) {
        Object description = String.format("resource '%s'", resource2);
        if (location != null) {
            description = (String)description + String.format(" via location '%s'", location);
        }
        return description;
    }

    public static void throwIfDoesNotExist(ConfigDataResource resource2, Path pathToCheck) {
        ConfigDataResourceNotFoundException.throwIfDoesNotExist(resource2, Files.exists(pathToCheck, new LinkOption[0]));
    }

    public static void throwIfDoesNotExist(ConfigDataResource resource2, File fileToCheck) {
        ConfigDataResourceNotFoundException.throwIfDoesNotExist(resource2, fileToCheck.exists());
    }

    public static void throwIfDoesNotExist(ConfigDataResource resource2, Resource resourceToCheck) {
        ConfigDataResourceNotFoundException.throwIfDoesNotExist(resource2, resourceToCheck.exists());
    }

    private static void throwIfDoesNotExist(ConfigDataResource resource2, boolean exists) {
        if (!exists) {
            throw new ConfigDataResourceNotFoundException(resource2);
        }
    }
}

