/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.exchanges.reactive;

import java.security.Principal;
import java.util.Set;
import org.springframework.boot.actuate.web.exchanges.HttpExchange;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.actuate.web.exchanges.Include;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpResponse;
import org.springframework.boot.actuate.web.exchanges.reactive.RecordableServerHttpRequest;
import org.springframework.boot.actuate.web.exchanges.reactive.RecordableServerHttpResponse;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class HttpExchangesWebFilter
implements WebFilter,
Ordered {
    private static final Object NONE = new Object();
    private int order = 0x7FFFFFF5;
    private final HttpExchangeRepository repository;
    private final Set<Include> includes;

    public HttpExchangesWebFilter(HttpExchangeRepository repository, Set<Include> includes) {
        this.repository = repository;
        this.includes = includes;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        Mono<Object> principal2 = exchange2.getPrincipal().cast(Object.class).defaultIfEmpty(NONE);
        Mono<Object> session = exchange2.getSession().cast(Object.class).defaultIfEmpty(NONE);
        return Mono.zip(PrincipalAndSession::new, principal2, session).flatMap(principalAndSession -> this.filter(exchange2, chain, (PrincipalAndSession)principalAndSession));
    }

    private Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain, PrincipalAndSession principalAndSession) {
        return Mono.fromRunnable(() -> this.addExchangeOnCommit(exchange2, principalAndSession)).and(chain.filter(exchange2));
    }

    private void addExchangeOnCommit(ServerWebExchange exchange2, PrincipalAndSession principalAndSession) {
        RecordableServerHttpRequest sourceRequest = new RecordableServerHttpRequest(exchange2.getRequest());
        HttpExchange.Started startedHttpExchange = HttpExchange.start(sourceRequest);
        exchange2.getResponse().beforeCommit(() -> {
            RecordableServerHttpResponse sourceResponse = new RecordableServerHttpResponse(exchange2.getResponse());
            HttpExchange finishedExchange = startedHttpExchange.finish((RecordableHttpResponse)sourceResponse, principalAndSession::getPrincipal, principalAndSession::getSessionId, this.includes);
            this.repository.add(finishedExchange);
            return Mono.empty();
        });
    }

    private static class PrincipalAndSession {
        private final Principal principal;
        private final WebSession session;

        PrincipalAndSession(Object[] zipped) {
            this.principal = zipped[0] != NONE ? (Principal)zipped[0] : null;
            this.session = zipped[1] != NONE ? (WebSession)zipped[1] : null;
        }

        Principal getPrincipal() {
            return this.principal;
        }

        String getSessionId() {
            return this.session != null && this.session.isStarted() ? this.session.getId() : null;
        }
    }
}

