/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.ServletWebRequest;

@Controller
public class ManagementErrorEndpoint {
    private final ErrorAttributes errorAttributes;
    private final ErrorProperties errorProperties;

    public ManagementErrorEndpoint(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        Assert.notNull((Object)errorAttributes, "ErrorAttributes must not be null");
        Assert.notNull((Object)errorProperties, "ErrorProperties must not be null");
        this.errorAttributes = errorAttributes;
        this.errorProperties = errorProperties;
    }

    @RequestMapping(value={"${server.error.path:${error.path:/error}}"})
    @ResponseBody
    public Map<String, Object> invoke(ServletWebRequest request) {
        return this.errorAttributes.getErrorAttributes(request, this.getErrorAttributeOptions(request));
    }

    private ErrorAttributeOptions getErrorAttributeOptions(ServletWebRequest request) {
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        if (this.errorProperties.isIncludeException()) {
            options = options.including(ErrorAttributeOptions.Include.EXCEPTION);
        }
        if (this.includeStackTrace(request)) {
            options = options.including(ErrorAttributeOptions.Include.STACK_TRACE);
        }
        if (this.includeMessage(request)) {
            options = options.including(ErrorAttributeOptions.Include.MESSAGE);
        }
        if (this.includeBindingErrors(request)) {
            options = options.including(ErrorAttributeOptions.Include.BINDING_ERRORS);
        }
        return options;
    }

    private boolean includeStackTrace(ServletWebRequest request) {
        return switch (this.errorProperties.getIncludeStacktrace()) {
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getBooleanParameter(request, "trace");
            default -> false;
        };
    }

    private boolean includeMessage(ServletWebRequest request) {
        return switch (this.errorProperties.getIncludeMessage()) {
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getBooleanParameter(request, "message");
            default -> false;
        };
    }

    private boolean includeBindingErrors(ServletWebRequest request) {
        return switch (this.errorProperties.getIncludeBindingErrors()) {
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getBooleanParameter(request, "errors");
            default -> false;
        };
    }

    protected boolean getBooleanParameter(ServletWebRequest request, String parameterName) {
        String parameter = request.getParameter(parameterName);
        if (parameter == null) {
            return false;
        }
        return !"false".equalsIgnoreCase(parameter);
    }
}

