/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.zipkin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.util.unit.DataSize;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.Sender;

abstract class HttpSender
extends Sender {
    private static final DataSize MESSAGE_MAX_SIZE = DataSize.ofKilobytes(512L);
    private volatile boolean closed;

    HttpSender() {
    }

    public Encoding encoding() {
        return Encoding.JSON;
    }

    public int messageMaxBytes() {
        return (int)MESSAGE_MAX_SIZE.toBytes();
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding().listSizeInBytes(encodedSizeInBytes);
    }

    public CheckResult check() {
        try {
            this.sendSpans(Collections.emptyList()).execute();
            return CheckResult.OK;
        }
        catch (IOException | RuntimeException ex) {
            return CheckResult.failed((Throwable)ex);
        }
    }

    public void close() throws IOException {
        this.closed = true;
    }

    protected abstract HttpPostCall sendSpans(byte[] var1);

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closed) {
            throw new ClosedSenderException();
        }
        return this.sendSpans(BytesMessageEncoder.JSON.encode(encodedSpans));
    }

    static abstract class HttpPostCall
    extends Call.Base<Void> {
        private static final DataSize COMPRESSION_THRESHOLD = DataSize.ofKilobytes(1L);
        private final byte[] body;

        HttpPostCall(byte[] body2) {
            this.body = body2;
        }

        protected byte[] getBody() {
            if (this.needsCompression()) {
                return this.compress(this.body);
            }
            return this.body;
        }

        protected byte[] getUncompressedBody() {
            return this.body;
        }

        protected HttpHeaders getDefaultHeaders() {
            HttpHeaders headers = new HttpHeaders();
            headers.set("b3", "0");
            headers.set("Content-Type", "application/json");
            if (this.needsCompression()) {
                headers.set("Content-Encoding", "gzip");
            }
            return headers;
        }

        private boolean needsCompression() {
            return (long)this.body.length > COMPRESSION_THRESHOLD.toBytes();
        }

        private byte[] compress(byte[] input) {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try (GZIPOutputStream gzip = new GZIPOutputStream(result);){
                gzip.write(input);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return result.toByteArray();
        }
    }
}

