/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationPredicate;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.util.StringUtils;

class PropertiesObservationFilterPredicate
implements ObservationFilter,
ObservationPredicate {
    private final ObservationFilter commonKeyValuesFilter;
    private final ObservationProperties properties;

    PropertiesObservationFilterPredicate(ObservationProperties properties) {
        this.properties = properties;
        this.commonKeyValuesFilter = PropertiesObservationFilterPredicate.createCommonKeyValuesFilter(properties);
    }

    @Override
    public Observation.Context map(Observation.Context context) {
        return this.commonKeyValuesFilter.map(context);
    }

    @Override
    public boolean test(String name, Observation.Context context) {
        return PropertiesObservationFilterPredicate.lookupWithFallbackToAll(this.properties.getEnable(), name, true);
    }

    private static <T> T lookupWithFallbackToAll(Map<String, T> values, String name, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return (T)PropertiesObservationFilterPredicate.doLookup(values, name, () -> values.getOrDefault("all", defaultValue));
    }

    private static <T> T doLookup(Map<String, T> values, String name, Supplier<T> defaultValue) {
        while (StringUtils.hasLength(name)) {
            T result = values.get(name);
            if (result != null) {
                return result;
            }
            int lastDot = name.lastIndexOf(46);
            name = lastDot != -1 ? name.substring(0, lastDot) : "";
        }
        return defaultValue.get();
    }

    private static ObservationFilter createCommonKeyValuesFilter(ObservationProperties properties) {
        if (properties.getKeyValues().isEmpty()) {
            return context -> context;
        }
        KeyValues keyValues = KeyValues.of(properties.getKeyValues().entrySet(), Map.Entry::getKey, Map.Entry::getValue);
        return context -> context.addLowCardinalityKeyValues(keyValues);
    }
}

