/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationHandlerGrouping;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryConfigurer;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryCustomizer;

class ObservationRegistryPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers;
    private final ObjectProvider<ObservationPredicate> observationPredicates;
    private final ObjectProvider<GlobalObservationConvention<?>> observationConventions;
    private final ObjectProvider<ObservationHandler<?>> observationHandlers;
    private final ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping;
    private final ObjectProvider<ObservationFilter> observationFilters;
    private volatile ObservationRegistryConfigurer configurer;

    ObservationRegistryPostProcessor(ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<GlobalObservationConvention<?>> observationConventions, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping, ObjectProvider<ObservationFilter> observationFilters) {
        this.observationRegistryCustomizers = observationRegistryCustomizers;
        this.observationPredicates = observationPredicates;
        this.observationConventions = observationConventions;
        this.observationHandlers = observationHandlers;
        this.observationHandlerGrouping = observationHandlerGrouping;
        this.observationFilters = observationFilters;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof ObservationRegistry) {
            ObservationRegistry registry = (ObservationRegistry)bean2;
            this.getConfigurer().configure(registry);
        }
        return bean2;
    }

    private ObservationRegistryConfigurer getConfigurer() {
        if (this.configurer == null) {
            this.configurer = new ObservationRegistryConfigurer(this.observationRegistryCustomizers, this.observationPredicates, this.observationConventions, this.observationHandlers, this.observationHandlerGrouping, this.observationFilters);
        }
        return this.configurer;
    }
}

