/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.fitting;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.optimization.DifferentiableMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.fitting.CurveFitter;
import org.apache.commons.math.optimization.fitting.ParametricRealFunction;

public class PolynomialFitter {
    private final CurveFitter fitter;
    private final int degree;

    public PolynomialFitter(int degree, DifferentiableMultivariateVectorialOptimizer optimizer) {
        this.fitter = new CurveFitter(optimizer);
        this.degree = degree;
    }

    public void addObservedPoint(double weight, double x, double y) {
        this.fitter.addObservedPoint(weight, x, y);
    }

    public void clearObservations() {
        this.fitter.clearObservations();
    }

    public PolynomialFunction fit() throws OptimizationException {
        try {
            return new PolynomialFunction(this.fitter.fit(new ParametricPolynomial(), new double[this.degree + 1]));
        }
        catch (FunctionEvaluationException fee) {
            throw new RuntimeException(fee);
        }
    }

    private static class ParametricPolynomial
    implements ParametricRealFunction {
        private ParametricPolynomial() {
        }

        public double[] gradient(double x, double[] parameters) {
            double[] gradient = new double[parameters.length];
            double xn = 1.0;
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                gradient[i2] = xn;
                xn *= x;
            }
            return gradient;
        }

        public double value(double x, double[] parameters) {
            double y = 0.0;
            for (int i2 = parameters.length - 1; i2 >= 0; --i2) {
                y = y * x + parameters[i2];
            }
            return y;
        }
    }
}

