/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.lang.reflect.Array;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.ArrayFieldVector;
import org.apache.commons.math.linear.FieldDecompositionSolver;
import org.apache.commons.math.linear.FieldLUDecomposition;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.SingularMatrixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldLUDecompositionImpl<T extends FieldElement<T>>
implements FieldLUDecomposition<T> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecompositionImpl(FieldMatrix<T> matrix) throws NonSquareMatrixException {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getColumnDimension();
        this.field = matrix.getField();
        this.lu = matrix.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (int row = 0; row < m; ++row) {
            this.pivot[row] = row;
        }
        this.even = true;
        this.singular = false;
        for (int col = 0; col < m; ++col) {
            FieldElement<T> sum = (FieldElement)this.field.getZero();
            for (int row = 0; row < col; ++row) {
                T[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i2 = 0; i2 < row; ++i2) {
                    sum = (FieldElement)sum.subtract(luRow[i2].multiply(this.lu[i2][col]));
                }
                luRow[col] = sum;
            }
            int nonZero = col;
            for (int row = col; row < m; ++row) {
                T[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i3 = 0; i3 < col; ++i3) {
                    sum = (FieldElement)sum.subtract(luRow[i3].multiply(this.lu[i3][col]));
                }
                luRow[col] = sum;
                if (!this.lu[nonZero][col].equals(this.field.getZero())) continue;
                ++nonZero;
            }
            if (nonZero >= m) {
                this.singular = true;
                return;
            }
            if (nonZero != col) {
                FieldElement tmp = (FieldElement)this.field.getZero();
                for (int i4 = 0; i4 < m; ++i4) {
                    tmp = this.lu[nonZero][i4];
                    this.lu[nonZero][i4] = this.lu[col][i4];
                    this.lu[col][i4] = tmp;
                }
                int temp = this.pivot[nonZero];
                this.pivot[nonZero] = this.pivot[col];
                this.pivot[col] = temp;
                this.even = !this.even;
            }
            T luDiag = this.lu[col][col];
            for (int row = col + 1; row < m; ++row) {
                T[] luRow = this.lu[row];
                luRow[col] = (FieldElement)luRow[col].divide(luDiag);
            }
        }
    }

    @Override
    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i2 = 0; i2 < m; ++i2) {
                T[] luI = this.lu[i2];
                for (int j = 0; j < i2; ++j) {
                    this.cachedL.setEntry(i2, j, luI[j]);
                }
                this.cachedL.setEntry(i2, i2, (FieldElement)this.field.getOne());
            }
        }
        return this.cachedL;
    }

    @Override
    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i2 = 0; i2 < m; ++i2) {
                T[] luI = this.lu[i2];
                for (int j = i2; j < m; ++j) {
                    this.cachedU.setEntry(i2, j, luI[j]);
                }
            }
        }
        return this.cachedU;
    }

    @Override
    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i2 = 0; i2 < m; ++i2) {
                this.cachedP.setEntry(i2, this.pivot[i2], (FieldElement)this.field.getOne());
            }
        }
        return this.cachedP;
    }

    @Override
    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    @Override
    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int m = this.pivot.length;
        FieldElement determinant = this.even ? (FieldElement)this.field.getOne() : (FieldElement)((FieldElement)this.field.getZero()).subtract(this.field.getOne());
        for (int i2 = 0; i2 < m; ++i2) {
            determinant = (FieldElement)determinant.multiply(this.lu[i2][i2]);
        }
        return (T)determinant;
    }

    @Override
    public FieldDecompositionSolver<T> getSolver() {
        return new Solver(this.field, (FieldElement[][])this.lu, this.pivot, this.singular);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Solver<T extends FieldElement<T>>
    implements FieldDecompositionSolver<T> {
        private static final long serialVersionUID = -6353105415121373022L;
        private final Field<T> field;
        private final T[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(Field<T> field, T[][] lu, int[] pivot, boolean singular) {
            this.field = field;
            this.lu = lu;
            this.pivot = pivot;
            this.singular = singular;
        }

        @Override
        public boolean isNonSingular() {
            return !this.singular;
        }

        @Override
        public T[] solve(T[] b) throws IllegalArgumentException, InvalidMatrixException {
            int i2;
            FieldElement bpCol;
            int col;
            int m = this.pivot.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            FieldElement[] bp = (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m);
            for (int row = 0; row < m; ++row) {
                bp[row] = b[this.pivot[row]];
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (i2 = col + 1; i2 < m; ++i2) {
                    bp[i2] = (FieldElement)bp[i2].subtract(bpCol.multiply(this.lu[i2][col]));
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bp[col] = (FieldElement)bp[col].divide(this.lu[col][col]);
                bpCol = bp[col];
                for (i2 = 0; i2 < col; ++i2) {
                    bp[i2] = (FieldElement)bp[i2].subtract(bpCol.multiply(this.lu[i2][col]));
                }
            }
            return bp;
        }

        @Override
        public FieldVector<T> solve(FieldVector<T> b) throws IllegalArgumentException, InvalidMatrixException {
            try {
                return this.solve((ArrayFieldVector)b);
            }
            catch (ClassCastException cce) {
                int i2;
                FieldElement bpCol;
                int col;
                int m = this.pivot.length;
                if (b.getDimension() != m) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.getDimension(), m);
                }
                if (this.singular) {
                    throw new SingularMatrixException();
                }
                FieldElement[] bp = (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m);
                for (int row = 0; row < m; ++row) {
                    bp[row] = b.getEntry(this.pivot[row]);
                }
                for (col = 0; col < m; ++col) {
                    bpCol = bp[col];
                    for (i2 = col + 1; i2 < m; ++i2) {
                        bp[i2] = (FieldElement)bp[i2].subtract(bpCol.multiply(this.lu[i2][col]));
                    }
                }
                for (col = m - 1; col >= 0; --col) {
                    bp[col] = (FieldElement)bp[col].divide(this.lu[col][col]);
                    bpCol = bp[col];
                    for (i2 = 0; i2 < col; ++i2) {
                        bp[i2] = (FieldElement)bp[i2].subtract(bpCol.multiply(this.lu[i2][col]));
                    }
                }
                return new ArrayFieldVector(bp, false);
            }
        }

        @Override
        public ArrayFieldVector<T> solve(ArrayFieldVector<T> b) throws IllegalArgumentException, InvalidMatrixException {
            return new ArrayFieldVector(this.solve(b.getDataRef()), false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) throws IllegalArgumentException, InvalidMatrixException {
            FieldElement[] bpCol;
            int col;
            int m = this.pivot.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int nColB = b.getColumnDimension();
            FieldElement[][] bp = (FieldElement[][])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m, nColB);
            for (int row = 0; row < m; ++row) {
                FieldElement[] bpRow = bp[row];
                int pRow = this.pivot[row];
                for (int col2 = 0; col2 < nColB; ++col2) {
                    bpRow[col2] = b.getEntry(pRow, col2);
                }
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (int i2 = col + 1; i2 < m; ++i2) {
                    FieldElement[] bpI = bp[i2];
                    T luICol = this.lu[i2][col];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = (FieldElement)bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bpCol = bp[col];
                T luDiag = this.lu[col][col];
                for (int j = 0; j < nColB; ++j) {
                    bpCol[j] = (FieldElement)bpCol[j].divide(luDiag);
                }
                for (int i3 = 0; i3 < col; ++i3) {
                    FieldElement[] bpI = bp[i3];
                    T luICol = this.lu[i3][col];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = (FieldElement)bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            return new Array2DRowFieldMatrix(bp, false);
        }

        @Override
        public FieldMatrix<T> getInverse() throws InvalidMatrixException {
            int m = this.pivot.length;
            FieldElement one = (FieldElement)this.field.getOne();
            Array2DRowFieldMatrix<FieldElement> identity = new Array2DRowFieldMatrix<FieldElement>(this.field, m, m);
            for (int i2 = 0; i2 < m; ++i2) {
                identity.setEntry(i2, i2, one);
            }
            return this.solve(identity);
        }
    }
}

