/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import java.util.List;
import java.util.Locale;
import org.apache.commons.jxpath.JXPathAbstractFactoryException;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.NamespaceResolver;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMAttributeIterator;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNamespaceIterator;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNamespacePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNodeIterator;
import org.apache.commons.jxpath.util.TypeUtils;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class JDOMNodePointer
extends NodePointer {
    private static final long serialVersionUID = -6346532297491082651L;
    private Object node;
    private String id;
    private NamespaceResolver localNamespaceResolver;
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    static /* synthetic */ Class class$java$lang$String;

    public JDOMNodePointer(Object node, Locale locale) {
        super(null, locale);
        this.node = node;
    }

    public JDOMNodePointer(Object node, Locale locale, String id) {
        super(null, locale);
        this.node = node;
        this.id = id;
    }

    public JDOMNodePointer(NodePointer parent, Object node) {
        super(parent);
        this.node = node;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return new JDOMNodeIterator(this, test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return new JDOMAttributeIterator(this, name);
    }

    public NodeIterator namespaceIterator() {
        return new JDOMNamespaceIterator(this);
    }

    public NodePointer namespacePointer(String prefix) {
        return new JDOMNamespacePointer((NodePointer)this, prefix);
    }

    public String getNamespaceURI() {
        return JDOMNodePointer.getNamespaceURI(this.node);
    }

    private static String getNamespaceURI(Object node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String ns = element.getNamespaceURI();
            if (ns != null && ns.equals("")) {
                ns = null;
            }
            return ns;
        }
        return null;
    }

    public synchronized NamespaceResolver getNamespaceResolver() {
        if (this.localNamespaceResolver == null) {
            this.localNamespaceResolver = new NamespaceResolver(super.getNamespaceResolver());
            this.localNamespaceResolver.setNamespaceContextPointer(this);
        }
        return this.localNamespaceResolver;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix.equals("xml")) {
            return Namespace.XML_NAMESPACE.getURI();
        }
        Element element = null;
        if (this.node instanceof Document) {
            element = ((Document)this.node).getRootElement();
        }
        if (this.node instanceof Element) {
            element = (Element)this.node;
        }
        if (element == null) {
            return null;
        }
        Namespace ns = element.getNamespace(prefix);
        return ns == null ? null : ns.getURI();
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        Object node2;
        Object node1 = pointer1.getBaseValue();
        if (node1 == (node2 = pointer2.getBaseValue())) {
            return 0;
        }
        if (node1 instanceof Attribute && !(node2 instanceof Attribute)) {
            return -1;
        }
        if (!(node1 instanceof Attribute) && node2 instanceof Attribute) {
            return 1;
        }
        if (node1 instanceof Attribute && node2 instanceof Attribute) {
            List list = ((Element)this.getNode()).getAttributes();
            int length = list.size();
            for (int i2 = 0; i2 < length; ++i2) {
                Object n = list.get(i2);
                if (n == node1) {
                    return -1;
                }
                if (n != node2) continue;
                return 1;
            }
            return 0;
        }
        if (!(this.node instanceof Element)) {
            throw new RuntimeException("JXPath internal error: compareChildNodes called for " + this.node);
        }
        List children = ((Element)this.node).getContent();
        int length = children.size();
        for (int i3 = 0; i3 < length; ++i3) {
            Object n = children.get(i3);
            if (n == node1) {
                return -1;
            }
            if (n != node2) continue;
            return 1;
        }
        return 0;
    }

    public Object getBaseValue() {
        return this.node;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public boolean isLeaf() {
        if (this.node instanceof Element) {
            return ((Element)this.node).getContent().size() == 0;
        }
        if (this.node instanceof Document) {
            return ((Document)this.node).getContent().size() == 0;
        }
        return true;
    }

    public QName getName() {
        String ns = null;
        String ln = null;
        if (this.node instanceof Element) {
            ns = ((Element)this.node).getNamespacePrefix();
            if (ns != null && ns.equals("")) {
                ns = null;
            }
            ln = ((Element)this.node).getName();
        } else if (this.node instanceof ProcessingInstruction) {
            ln = ((ProcessingInstruction)this.node).getTarget();
        }
        return new QName(ns, ln);
    }

    public Object getImmediateNode() {
        return this.node;
    }

    public Object getValue() {
        if (this.node instanceof Element) {
            StringBuffer buf = new StringBuffer();
            NodeIterator children = this.childIterator(null, false, null);
            while (children.setPosition(children.getPosition() + 1)) {
                NodePointer ptr = children.getNodePointer();
                if (!(ptr.getImmediateNode() instanceof Element) && !(ptr.getImmediateNode() instanceof Text)) continue;
                buf.append(ptr.getValue());
            }
            return buf.toString();
        }
        if (this.node instanceof Comment) {
            String text = ((Comment)this.node).getText();
            if (text != null) {
                text = text.trim();
            }
            return text;
        }
        String result = null;
        if (this.node instanceof Text) {
            result = ((Text)this.node).getText();
        }
        if (this.node instanceof ProcessingInstruction) {
            result = ((ProcessingInstruction)this.node).getData();
        }
        boolean trim = !"preserve".equals(JDOMNodePointer.findEnclosingAttribute(this.node, "space", Namespace.XML_NAMESPACE));
        return result != null && trim ? result.trim() : result;
    }

    public void setValue(Object value) {
        if (this.node instanceof Text) {
            String string = (String)TypeUtils.convert(value, class$java$lang$String == null ? (class$java$lang$String = JDOMNodePointer.class$("java.lang.String")) : class$java$lang$String);
            if (string != null && !string.equals("")) {
                ((Text)this.node).setText(string);
            } else {
                JDOMNodePointer.nodeParent(this.node).removeContent((Content)((Text)this.node));
            }
        } else {
            Element element = (Element)this.node;
            element.getContent().clear();
            if (value instanceof Element) {
                Element valueElement = (Element)value;
                this.addContent(valueElement.getContent());
            } else if (value instanceof Document) {
                Document valueDocument = (Document)value;
                this.addContent(valueDocument.getContent());
            } else if (value instanceof Text || value instanceof CDATA) {
                String string = ((Text)value).getText();
                element.addContent((Content)new Text(string));
            } else if (value instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)((ProcessingInstruction)value).clone();
                element.addContent((Content)pi);
            } else if (value instanceof Comment) {
                Comment comment = (Comment)((Comment)value).clone();
                element.addContent((Content)comment);
            } else {
                String string = (String)TypeUtils.convert(value, class$java$lang$String == null ? (class$java$lang$String = JDOMNodePointer.class$("java.lang.String")) : class$java$lang$String);
                if (string != null && !string.equals("")) {
                    element.addContent((Content)new Text(string));
                }
            }
        }
    }

    private void addContent(List content) {
        Element element = (Element)this.node;
        int count = content.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Object child = content.get(i2);
            if (child instanceof Element) {
                child = ((Element)child).clone();
                element.addContent((Content)((Element)child));
                continue;
            }
            if (child instanceof Text) {
                child = ((Text)child).clone();
                element.addContent((Content)((Text)child));
                continue;
            }
            if (this.node instanceof CDATA) {
                child = ((CDATA)child).clone();
                element.addContent((Content)((CDATA)child));
                continue;
            }
            if (this.node instanceof ProcessingInstruction) {
                child = ((ProcessingInstruction)child).clone();
                element.addContent((Content)((ProcessingInstruction)child));
                continue;
            }
            if (!(this.node instanceof Comment)) continue;
            child = ((Comment)child).clone();
            element.addContent((Content)((Comment)child));
        }
    }

    public boolean testNode(NodeTest test) {
        return JDOMNodePointer.testNode(this, this.node, test);
    }

    public static boolean testNode(NodePointer pointer, Object node, NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            if (!(node instanceof Element)) {
                return false;
            }
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            String namespaceURI = nodeNameTest.getNamespaceURI();
            boolean wildcard = nodeNameTest.isWildcard();
            String testPrefix = testName.getPrefix();
            if (wildcard && testPrefix == null) {
                return true;
            }
            if (wildcard || testName.getName().equals(JDOMNodePointer.getLocalName(node))) {
                String nodeNS = JDOMNodePointer.getNamespaceURI(node);
                return JDOMNodePointer.equalStrings(namespaceURI, nodeNS) || nodeNS == null && JDOMNodePointer.equalStrings(testPrefix, JDOMNodePointer.getPrefix(node));
            }
            return false;
        }
        if (test instanceof NodeTypeTest) {
            switch (((NodeTypeTest)test).getNodeType()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return node instanceof Text || node instanceof CDATA;
                }
                case 3: {
                    return node instanceof Comment;
                }
                case 4: {
                    return node instanceof ProcessingInstruction;
                }
            }
            return false;
        }
        if (test instanceof ProcessingInstructionTest && node instanceof ProcessingInstruction) {
            String testPI = ((ProcessingInstructionTest)test).getTarget();
            String nodePI = ((ProcessingInstruction)node).getTarget();
            return testPI.equals(nodePI);
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        s1 = s1 == null ? "" : s1.trim();
        s2 = s2 == null ? "" : s2.trim();
        return s1.equals(s2);
    }

    public static String getPrefix(Object node) {
        if (node instanceof Element) {
            String prefix = ((Element)node).getNamespacePrefix();
            return prefix == null || prefix.equals("") ? null : prefix;
        }
        if (node instanceof Attribute) {
            String prefix = ((Attribute)node).getNamespacePrefix();
            return prefix == null || prefix.equals("") ? null : prefix;
        }
        return null;
    }

    public static String getLocalName(Object node) {
        if (node instanceof Element) {
            return ((Element)node).getName();
        }
        if (node instanceof Attribute) {
            return ((Attribute)node).getName();
        }
        return null;
    }

    public boolean isLanguage(String lang) {
        String current = this.getLanguage();
        return current == null ? super.isLanguage(lang) : current.toUpperCase(Locale.ENGLISH).startsWith(lang.toUpperCase(Locale.ENGLISH));
    }

    protected String getLanguage() {
        return JDOMNodePointer.findEnclosingAttribute(this.node, "lang", Namespace.XML_NAMESPACE);
    }

    protected static String findEnclosingAttribute(Object n, String attrName, Namespace ns) {
        while (n != null) {
            Element e;
            String attr;
            if (n instanceof Element && (attr = (e = (Element)n).getAttributeValue(attrName, ns)) != null && !attr.equals("")) {
                return attr;
            }
            n = JDOMNodePointer.nodeParent(n);
        }
        return null;
    }

    private static Element nodeParent(Object node) {
        if (node instanceof Element) {
            Parent parent = ((Element)node).getParent();
            return parent instanceof Element ? (Element)parent : null;
        }
        if (node instanceof Text) {
            return (Element)((Text)node).getParent();
        }
        if (node instanceof CDATA) {
            return (Element)((CDATA)node).getParent();
        }
        if (node instanceof ProcessingInstruction) {
            return (Element)((ProcessingInstruction)node).getParent();
        }
        if (node instanceof Comment) {
            return (Element)((Comment)node).getParent();
        }
        return null;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        String prefix;
        String namespaceURI;
        NodeNameTest nodeTest;
        NodeIterator it;
        boolean success;
        if (index == Integer.MIN_VALUE) {
            index = 0;
        }
        if ((success = this.getAbstractFactory(context).createObject(context, this, this.node, name.toString(), index)) && (it = this.childIterator(nodeTest = new NodeNameTest(name, namespaceURI = (prefix = name.getPrefix()) == null ? null : context.getNamespaceURI(prefix)), false, null)) != null && it.setPosition(index + 1)) {
            return it.getNodePointer();
        }
        throw new JXPathAbstractFactoryException("Factory could not create a child node for path: " + this.asPath() + "/" + name + "[" + (index + 1) + "]");
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        NodePointer ptr = this.createChild(context, name, index);
        ptr.setValue(value);
        return ptr;
    }

    public NodePointer createAttribute(JXPathContext context, QName name) {
        if (!(this.node instanceof Element)) {
            return super.createAttribute(context, name);
        }
        Element element = (Element)this.node;
        String prefix = name.getPrefix();
        if (prefix != null) {
            String namespaceUri = this.getNamespaceResolver().getNamespaceURI(prefix);
            if (namespaceUri == null) {
                throw new JXPathException("Unknown namespace prefix: " + prefix);
            }
            Namespace ns = Namespace.getNamespace((String)prefix, (String)namespaceUri);
            Attribute attr = element.getAttribute(name.getName(), ns);
            if (attr == null) {
                element.setAttribute(name.getName(), "", ns);
            }
        } else {
            Attribute attr = element.getAttribute(name.getName());
            if (attr == null) {
                element.setAttribute(name.getName(), "");
            }
        }
        NodeIterator it = this.attributeIterator(name);
        it.setPosition(1);
        return it.getNodePointer();
    }

    public void remove() {
        Element parent = JDOMNodePointer.nodeParent(this.node);
        if (parent == null) {
            throw new JXPathException("Cannot remove root JDOM node");
        }
        parent.getContent().remove(this.node);
    }

    public String asPath() {
        if (this.id != null) {
            return "id('" + this.escape(this.id) + "')";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        if (this.node instanceof Element) {
            if (this.parent instanceof JDOMNodePointer) {
                if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                    buffer.append('/');
                }
                String nsURI = this.getNamespaceURI();
                String ln = JDOMNodePointer.getLocalName(this.node);
                if (nsURI == null) {
                    buffer.append(ln);
                    buffer.append('[');
                    buffer.append(this.getRelativePositionByName()).append(']');
                } else {
                    String prefix = this.getNamespaceResolver().getPrefix(nsURI);
                    if (prefix != null) {
                        buffer.append(prefix);
                        buffer.append(':');
                        buffer.append(ln);
                        buffer.append('[');
                        buffer.append(this.getRelativePositionByName());
                        buffer.append(']');
                    } else {
                        buffer.append("node()");
                        buffer.append('[');
                        buffer.append(this.getRelativePositionOfElement());
                        buffer.append(']');
                    }
                }
            }
        } else if (this.node instanceof Text || this.node instanceof CDATA) {
            buffer.append("/text()");
            buffer.append('[').append(this.getRelativePositionOfTextNode()).append(']');
        } else if (this.node instanceof ProcessingInstruction) {
            buffer.append("/processing-instruction('").append(((ProcessingInstruction)this.node).getTarget()).append("')");
            buffer.append('[').append(this.getRelativePositionOfPI()).append(']');
        }
        return buffer.toString();
    }

    private int getRelativePositionByName() {
        if (this.node instanceof Element) {
            Parent parent = ((Element)this.node).getParent();
            if (!(parent instanceof Element)) {
                return 1;
            }
            List children = ((Element)parent).getContent();
            int count = 0;
            String name = ((Element)this.node).getQualifiedName();
            for (int i2 = 0; i2 < children.size(); ++i2) {
                Object child = children.get(i2);
                if (child instanceof Element && ((Element)child).getQualifiedName().equals(name)) {
                    ++count;
                }
                if (child == this.node) break;
            }
            return count;
        }
        return 1;
    }

    private int getRelativePositionOfElement() {
        Parent parent = ((Element)this.node).getParent();
        if (parent == null) {
            return 1;
        }
        List children = parent instanceof Element ? ((Element)parent).getContent() : ((Document)parent).getContent();
        int count = 0;
        for (int i2 = 0; i2 < children.size(); ++i2) {
            Object child = children.get(i2);
            if (child instanceof Element) {
                ++count;
            }
            if (child == this.node) break;
        }
        return count;
    }

    private int getRelativePositionOfTextNode() {
        Element parent = this.node instanceof Text ? (Element)((Text)this.node).getParent() : (Element)((CDATA)this.node).getParent();
        if (parent == null) {
            return 1;
        }
        List children = parent.getContent();
        int count = 0;
        for (int i2 = 0; i2 < children.size(); ++i2) {
            Object child = children.get(i2);
            if (child instanceof Text || child instanceof CDATA) {
                ++count;
            }
            if (child == this.node) break;
        }
        return count;
    }

    private int getRelativePositionOfPI() {
        String target = ((ProcessingInstruction)this.node).getTarget();
        Element parent = (Element)((ProcessingInstruction)this.node).getParent();
        if (parent == null) {
            return 1;
        }
        List children = parent.getContent();
        int count = 0;
        for (int i2 = 0; i2 < children.size(); ++i2) {
            Object child = children.get(i2);
            if (child instanceof ProcessingInstruction && (target == null || target.equals(((ProcessingInstruction)child).getTarget()))) {
                ++count;
            }
            if (child == this.node) break;
        }
        return count;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JDOMNodePointer)) {
            return false;
        }
        JDOMNodePointer other = (JDOMNodePointer)object;
        return this.node == other.node;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

