/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.netflix.servo.tag.Tag;
import com.netflix.servo.util.Preconditions;
import com.netflix.servo.util.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallTagMap
implements Iterable<Tag> {
    public static final int MAX_TAGS = 32;
    public static final int INITIAL_TAG_SIZE = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(SmallTagMap.class);
    private int cachedHashCode = 0;
    private final Tag[] tagArray;

    public static Builder builder() {
        return new Builder(8);
    }

    @Override
    public Iterator<Tag> iterator() {
        return new SmallTagIterator();
    }

    SmallTagMap(Tag[] tagArray) {
        this.tagArray = Preconditions.checkNotNull(tagArray, "tagArray");
    }

    static int binarySearch(Tag[] a, String key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Tag midValTag = a[mid];
            String midVal = midValTag.getKey();
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public Tag get(String key) {
        int idx = SmallTagMap.binarySearch(this.tagArray, key);
        if (idx < 0) {
            return null;
        }
        return this.tagArray[idx];
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = Arrays.hashCode(this.tagArray);
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return "SmallTagMap{" + Strings.join(",", this.iterator()) + "}";
    }

    public boolean containsKey(String k) {
        return this.get(k) != null;
    }

    public boolean isEmpty() {
        return this.tagArray.length == 0;
    }

    public int size() {
        return this.tagArray.length;
    }

    @Deprecated
    public Set<Tag> tagSet() {
        return new HashSet<Tag>(Arrays.asList(this.tagArray));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SmallTagMap)) {
            return false;
        }
        SmallTagMap that = (SmallTagMap)obj;
        return Arrays.equals(this.tagArray, that.tagArray);
    }

    private class SmallTagIterator
    implements Iterator<Tag> {
        private int i = 0;

        private SmallTagIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < SmallTagMap.this.tagArray.length;
        }

        @Override
        public Tag next() {
            if (this.i < SmallTagMap.this.tagArray.length) {
                return SmallTagMap.this.tagArray[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SmallTagMaps are immutable");
        }
    }

    public static class Builder {
        private int actualSize = 0;
        private int size;
        private Object[] buf;

        private void init(int size) {
            this.size = size;
            this.buf = new Object[size * 2];
            this.actualSize = 0;
        }

        public Builder(int size) {
            this.init(size);
        }

        public int size() {
            return this.actualSize;
        }

        public boolean isEmpty() {
            return this.actualSize == 0;
        }

        private void resizeIfPossible(Tag tag) {
            if (this.size < 32) {
                Object[] prevBuf = this.buf;
                this.init(this.size * 2);
                for (int i2 = 1; i2 < prevBuf.length; i2 += 2) {
                    Tag t = (Tag)prevBuf[i2];
                    if (t == null) continue;
                    this.add(t);
                }
                this.add(tag);
            } else {
                String msg = String.format("Cannot add Tag %s - Maximum number of tags (%d) reached.", tag, 32);
                LOGGER.error(msg);
            }
        }

        public Builder add(Tag tag) {
            int pos;
            String k = tag.getKey();
            int i2 = pos = (int)(Math.abs((long)k.hashCode()) % (long)this.size);
            Object ki = this.buf[i2 * 2];
            while (ki != null && !ki.equals(k)) {
                if ((i2 = (i2 + 1) % this.size) == pos) {
                    this.resizeIfPossible(tag);
                    return this;
                }
                ki = this.buf[i2 * 2];
            }
            if (ki != null) {
                this.buf[i2 * 2] = k;
                this.buf[i2 * 2 + 1] = tag;
            } else {
                if (this.buf[i2 * 2] != null) {
                    throw new IllegalStateException("position has already been filled");
                }
                this.buf[i2 * 2] = k;
                this.buf[i2 * 2 + 1] = tag;
                ++this.actualSize;
            }
            return this;
        }

        public Builder addAll(Iterable<Tag> tags) {
            for (Tag tag : tags) {
                this.add(tag);
            }
            return this;
        }

        public SmallTagMap result() {
            Tag[] tagArray = new Tag[this.actualSize];
            int tagIdx = 0;
            for (int i2 = 1; i2 < this.buf.length; i2 += 2) {
                Object o = this.buf[i2];
                if (o == null) continue;
                tagArray[tagIdx++] = (Tag)o;
            }
            Arrays.sort(tagArray, (o1, o2) -> {
                int keyCmp = o1.getKey().compareTo(o2.getKey());
                if (keyCmp != 0) {
                    return keyCmp;
                }
                return o1.getValue().compareTo(o2.getValue());
            });
            assert (tagIdx == this.actualSize);
            return new SmallTagMap(tagArray);
        }
    }
}

